package netjfwatcher.birt.gui.editorparts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.birt.preference.ReportDesignFilePreference;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.DBTableAlarm;
import netjfwatcher.database.access.model.DBTableBase;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class AlarmListTableReportEditorView extends AbstractReportEditorView {
	/* MO */
	private static Logger logger;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public AlarmListTableReportEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	protected void setReportFile(int selectNo) throws EngineException,
			FileNotFoundException, IOException, Exception {
		String reportFileName = getReportDesignFile(ReportDesignFilePreference.ALARM_LIST_REPORT_DESIGN);

		String outputFileRenderOption = "";
		if (selectNo != PREVIEW) {
			String fileName = "alarmlist";
			if (targetNodeInfo != null) {
				String ipAddress = targetNodeInfo.getIpaddress();
				String convIPAddress = DBTableBase.IP
						+ ipAddress.replace('.', '_') + "_Alarm";
				fileName = convIPAddress;
			}

			String fileExt = "";
			switch (selectNo) {
			case HTML_OUT:
				fileExt = ASTALISK + HTML_FILE_EXT;
				fileName = fileName + HTML_FILE_EXT;
				break;
			case PDF_OUT:
				fileExt = ASTALISK + PDF_FILE_EXT;
				fileName = fileName + PDF_FILE_EXT;
				break;
			default:
				break;
			}

			outputFileRenderOption = setOutputFileDialog(fileName, fileExt);
		}

		previewReport(selectNo, reportFileName, outputFileRenderOption);
	}

	protected void serDataSet(IReportRunnable design) throws SemanticException {
		String ipAddress = null;
		if (targetNodeInfo != null) {
			ipAddress = targetNodeInfo.getIpaddress();
		}

		// design.set
		List contents2 = design.getDesignHandle().getModuleHandle()
				.getAllDataSets();
		for (int i = 0; i < contents2.size(); i++) {
			OdaDataSetHandle dataSet = (OdaDataSetHandle) contents2.get(i);

			if (ipAddress != null) {
				String sql = getSql(ipAddress, null, null);
				System.out.println("sql " + sql);
				if (sql != null && !sql.equals("")) {
					dataSet.setQueryText(sql);
				}
			}

		}

	}

	protected String getSql(String ipaddress, String startTime, String endTime) {
		String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
		String tableName = DBTableAlarm.ALARM_TABLE;
		String sql = "";
		if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
				AbstractDataAccessObject.DERBY)
				|| DatabaseAccessControlKind.getInstance().getDatabaseName()
						.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {

			sql = "SELECT * from " + DBTableAlarm.ALARM_TABLE + " where "
					+ DBTableAlarm.ALARM_CONFIRM.toUpperCase() + " = " + "'"
					+ DBTableAlarm.UNCONFIRM + "' " + " and "
					+ DBTableAlarm.IPADDRESS.toUpperCase() + "=" + "'"
					+ ipaddress + "' " + " order by "
					+ DBTableAlarm.INIT_SORT_COLUMN.toUpperCase() + " "
					+ DBTableAlarm.INIT_SORT_DIRECTION;
			return sql;
		} else {

			sql = "SELECT * from " + DBTableAlarm.ALARM_TABLE + " where "
					+ DBTableAlarm.ALARM_CONFIRM + " = " + "'"
					+ DBTableAlarm.UNCONFIRM + "' " + " and "
					+ DBTableAlarm.IPADDRESS + "=" + "'" + ipaddress + "' "
					+ " order by " + DBTableAlarm.INIT_SORT_COLUMN + " "
					+ DBTableAlarm.INIT_SORT_DIRECTION;
			return sql;
		}
	}

}
