package netjfwatcher.birt.gui.editorparts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.birt.preference.ReportDesignFilePreference;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTableInterfaceMIB;
import netjfwatcher.database.access.model.DBTableSystemMIB;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class NodeSnmpReportEditorView extends AbstractReportEditorView {
	/* MO */
	private static Logger logger;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public NodeSnmpReportEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	protected void setReportFile(int selectNo) throws EngineException,
			FileNotFoundException, IOException, Exception {
		String reportFileName = getReportDesignFile(ReportDesignFilePreference.NODE_SNMP_REPORT_DESIGN);
		String outputFileRenderOption = "";
		if (selectNo != PREVIEW) {
			String ipAddress = targetNodeInfo.getIpaddress();
			String convIPAddress = DBTableBase.IP + ipAddress.replace('.', '_')
					+ "_SNMP";
			String fileExt = "";
			switch (selectNo) {
			case HTML_OUT:
				fileExt = ASTALISK + HTML_FILE_EXT;
				convIPAddress = convIPAddress + HTML_FILE_EXT;
				break;
			case PDF_OUT:
				fileExt = ASTALISK + PDF_FILE_EXT;
				convIPAddress = convIPAddress + PDF_FILE_EXT;
				break;
			default:
				break;
			}

			outputFileRenderOption = setOutputFileDialog(convIPAddress, fileExt);
		}

		previewReport(selectNo, reportFileName, outputFileRenderOption);
	}

	protected void serDataSet(IReportRunnable design) throws SemanticException {

		String ipAddress = targetNodeInfo.getIpaddress();
		System.out.println("ipAddress " + ipAddress);
		// design.set
		List contents2 = design.getDesignHandle().getModuleHandle()
				.getAllDataSets();

		for (int i = 0; i < contents2.size(); i++) {
			OdaDataSetHandle dataSet = (OdaDataSetHandle) contents2.get(i);

			List resultSetList = dataSet.getListProperty("resultSet");
			for (int j = 0; j < resultSetList.size(); j++) {
				ResultSetColumn struct = (ResultSetColumn) resultSetList.get(j);

				// System.out.println("struct.getProperty name " +
				// struct.getColumnName());
			}

			CachedMetaDataHandle ca = dataSet.getCachedMetaDataHandle();
			MemberHandle ha = ca.getResultSet();

			System.out.println("getModule "
					+ design.getDesignHandle().getModule());

			System.out.println("queryText " + dataSet.getQueryText());
			System.out
					.println("getResultSetName " + dataSet.getResultSetName());
			// design.getDesignHandle().getModuleHandle().getDataSets().getElementHandle().getName()
			System.out.println("getName " + dataSet.getName());
			if (ipAddress != null) {

				if (dataSet.getName().equals("node_snmp_sys")) {
					String sql = getSystemMibSql(ipAddress);
					System.out.println("sql " + sql);
					if (sql != null && !sql.equals("")) {
						dataSet.setQueryText(sql);
					}
				}
				if (dataSet.getName().equals("node_snmp_if")) {
					String sql = getInterfaceMibSql(ipAddress);
					System.out.println("sql " + sql);
					if (sql != null && !sql.equals("")) {
						dataSet.setQueryText(sql);
					}
				}

			}

		}

	}

	protected String getSystemMibSql(String ipaddress) {
		String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
		String tableName = convIPAddress.replace('-', '_')
				+ DBTableSystemMIB.SNMP_SYS_TABLE_NAME;

		if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
				AbstractDataAccessObject.DERBY)
				|| DatabaseAccessControlKind.getInstance().getDatabaseName()
						.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			String sql = "SELECT * from " + tableName.toUpperCase()
					+ " order by " + DBTableSystemMIB.SYS_CURDATE.toUpperCase()
					+ " desc";

			return sql;
		} else {

			String sql = "SELECT * from " + tableName + " order by "
					+ DBTableSystemMIB.SYS_CURDATE + " desc";

			return sql;
		}
	}

	protected String getInterfaceMibSql(String ipaddress) {
		String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
		String tableName = convIPAddress.replace('-', '_')
				+ DBTableInterfaceMIB.SNMP_IF_TABLE_NAME;
		if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
				AbstractDataAccessObject.DERBY)
				|| DatabaseAccessControlKind.getInstance().getDatabaseName()
						.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {
			String sql = "SELECT * from " + tableName.toUpperCase()
					+ " order by " + DBTableInterfaceMIB.IF_INDEX.toUpperCase()
					+ " asc";

			return sql;
		} else {
			String sql = "SELECT * from " + tableName + " order by "
					+ DBTableInterfaceMIB.IF_INDEX + " asc";

			return sql;
		}
	}

}