package netjfwatcher.birt.gui.editorparts;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.birt.preference.ReportDesignFilePreference;
import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.DBTableBase;
import netjfwatcher.database.access.model.DBTablePingResponse;

import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class PingGraphReportEditorView extends AbstractReportEditorView {
	/* MO */
	private static Logger logger;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public PingGraphReportEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	protected void setReportFile(int selectNo) throws EngineException,
			FileNotFoundException, IOException, Exception {
		String reportFileName = getReportDesignFile(ReportDesignFilePreference.NODE_PING_GRAPH_REPORT_DESIGN);
		String outputFileRenderOption = "";
		if (selectNo != PREVIEW) {
			String ipAddress = targetNodeInfo.getIpaddress();
			String convIPAddress = DBTableBase.IP + ipAddress.replace('.', '_')
					+ "_PingGraph";

			String fileExt = "";
			switch (selectNo) {
			case HTML_OUT:
				fileExt = ASTALISK + HTML_FILE_EXT;
				convIPAddress = convIPAddress + HTML_FILE_EXT;
				break;
			case PDF_OUT:
				fileExt = ASTALISK + PDF_FILE_EXT;
				convIPAddress = convIPAddress + PDF_FILE_EXT;
				break;
			default:
				break;
			}

			outputFileRenderOption = setOutputFileDialog(convIPAddress, fileExt);
		}

		previewReport(selectNo, reportFileName, outputFileRenderOption);
	}

	protected String getSql(String ipaddress, String startTime, String endTime) {
		String convIPAddress = DBTableBase.IP + ipaddress.replace('.', '_');
		String tableName = convIPAddress.replace('-', '_')
				+ DBTablePingResponse.PING_RESPONSE_TABLE_NAME;
		String sql = "";
		if (DatabaseAccessControlKind.getInstance().getDatabaseName().equals(
				AbstractDataAccessObject.DERBY)
				|| DatabaseAccessControlKind.getInstance().getDatabaseName()
						.equals(AbstractDataAccessObject.EMBEDDED_DERBY)) {

			// sql̍쐬
			if ((startTime == null) || (endTime == null)) {
				sql = "select * from " + tableName.toUpperCase() + " order by "
						+ DBTablePingResponse.CURDATE.toUpperCase() + " desc";
			} else {
				sql = "select * from " + tableName.toUpperCase() + " where "
						+ DBTablePingResponse.CURDATE + " between " + "'"
						+ startTime + "'" + " and " + "'" + endTime + "'"
						+ " order by "
						+ DBTablePingResponse.CURDATE.toUpperCase() + " desc";
			}
			return sql;
		} else {

			// sql̍쐬
			if ((startTime == null) || (endTime == null)) {
				sql = "select * from " + tableName + " order by "
						+ DBTablePingResponse.CURDATE + " desc";
			} else {
				sql = "select * from " + tableName + " where "
						+ DBTablePingResponse.CURDATE + " between " + "'"
						+ startTime + "'" + " and " + "'" + endTime + "'"
						+ " order by " + DBTablePingResponse.CURDATE + " desc";
			}
			return sql;
		}
	}

}
