package netjfwatcher.birt.gui.editorparts;

import java.util.logging.Logger;

import netjfwatcher.birt.action.PreviewBirtAction;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;

import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;


public class PreviewBirtViewer extends AbstractReportEditorView {
	/* MO */
	private static Logger logger;



	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public PreviewBirtViewer() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

    /* (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {

        parent.setLayout(new GridLayout());
        GridData gd = new GridData(GridData.FILL_HORIZONTAL);
          
        Group reportGroup = new Group(parent,SWT.SHADOW_IN);
        reportGroup.setText("Select report:");
        GridLayout layout = new GridLayout(2, false);        
        reportGroup.setLayout(layout);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        reportGroup.setLayoutData(gd);
        
        gd = new GridData();
        gd.horizontalSpan = 2;
                
        Label label = new Label(reportGroup, SWT.NONE);
        label.setText("Full Path:");
        
        label.setLayoutData(gd);

        reportLocationText = new Text(reportGroup, SWT.BORDER);
        gd = new GridData(GridData.FILL_HORIZONTAL);
        reportLocationText.setLayoutData(gd);
        //setPageComplete(false);
        reportLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e)
            {
            	//
            }
            
        });
        
        browseFolderButton = new Button(reportGroup, SWT.RIGHT);
        browseFolderButton.setText("..."); //$NON-NLS-1$
        browseFolderButton.addSelectionListener(new SelectionAdapter(){

            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetSelected(SelectionEvent e)
            {
            	FileDialog dialog = new FileDialog(reportLocationText.getShell());
            	String [] extension = { "*.rptdesign"};
            	dialog.setFilterExtensions(extension);
                if(reportLocationText.getText() != null && reportLocationText.getText().trim().length() > 0)
                {
               	
                    dialog.setFilterPath(reportLocationText.getText());
                   
                }
                
                String selectedLocation = dialog.open();
                if(selectedLocation != null)
                {
                	reportLocationText.setText(selectedLocation);
                }
            }
            
        });
                
        Button showReport = new Button(reportGroup, SWT.PUSH);
        showReport.setText("Run Report");
         
        showReport.addSelectionListener(new SelectionListener(){
          
            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetSelected(SelectionEvent e) {
            	previewReport();
            	//addReportParameters(lParent, gridData);
                //openReportRunner();
            }
            /* (non-Javadoc)
             * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
             */
            public void widgetDefaultSelected(SelectionEvent e) {
                // TODO Auto-generated method stub

            }
        });
        
    
		browser = new Browser( parent, SWT.NONE );
		gd = new GridData( GridData.FILL_BOTH );
		gd.horizontalSpan = 2;
		browser.setLayoutData( gd );
		browser.addLocationListener( new LocationAdapter( ) {

			public void changed( final LocationEvent e )
			{
				progressBar.setVisible( false );
			}

			public void changing( final LocationEvent e )
			{
				progressBar.setVisible( true );
			}
		} );

		gd = new GridData( GridData.END, GridData.CENTER, false, false );
		//gd = new GridData( GridData.FILL_BOTH );
		gd.heightHint = 10;
		gd.widthHint = 100;  
		progressBar = new ProgressBar( parent, SWT.INDETERMINATE );
		progressBar.setLayoutData( gd );
		progressBar.setVisible( false ); 

		//super.createPartControl( browser );

		WebViewer.startup( browser );
        
    }

    private void previewReport(){

    	String report = reportLocationText.getText();
 
    	if (report.length() != 0) {
    		
    		//addReportParameters(this.lParent,new GridData( GridData.END, GridData.CENTER, false, false ));
    		
    		PreviewBirtAction preview = new PreviewBirtAction();
    		preview.setReportName(report);
    		preview.setBrowser(browser);
    		preview.run();
    		preview.dispose();
    	}
    }


	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}
}
