/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.gui.editorparts;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.birt.preference.ReportDesignFilePreference;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;

import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;

public class ReportEngineSetReportLocationEditorView extends
		AbstractReportEditorView {
	/* MO */
	private static Logger logger;

	private static final int HORIZONTAL_SPAN4 = 4;

	private static final int HORIZONTAL_SPAN3 = 3;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public ReportEngineSetReportLocationEditorView() {
		logger = Logger.getLogger(this.getClass().getName());

		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		parent.setLayout(new GridLayout());
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);

		Group reportGroup = new Group(parent, SWT.SHADOW_IN);
		reportGroup.setText("Select report:");
		GridLayout layout = new GridLayout(HORIZONTAL_SPAN4, false);
		reportGroup.setLayout(layout);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		reportGroup.setLayoutData(gd);

		gd = new GridData();
		gd.horizontalSpan = HORIZONTAL_SPAN4;

		Label label = new Label(reportGroup, SWT.NONE);
		label.setText("Full Path:");

		label.setLayoutData(gd);

		reportLocationText = new Text(reportGroup, SWT.BORDER);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = HORIZONTAL_SPAN3;
		gd.verticalSpan = 1;

		reportLocationText.setLayoutData(gd);
		// setPageComplete(false);

		browseFolderButton = new Button(reportGroup, SWT.RIGHT);
		browseFolderButton.setText("..."); //$NON-NLS-1$

		showReportButton = new Button(reportGroup, SWT.PUSH);
		showReportButton.setText("Run Report");
		htmlOutputButton = new Button(reportGroup, SWT.PUSH);
		htmlOutputButton.setText("html output");
		pdfOutputButton = new Button(reportGroup, SWT.PUSH);
		pdfOutputButton.setText("pdf output");

		browser = new Browser(parent, SWT.NONE);
		gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = HORIZONTAL_SPAN4;
		browser.setLayoutData(gd);

		gd = new GridData(GridData.END, GridData.CENTER, false, false);
		// gd = new GridData( GridData.FILL_BOTH );
		gd.heightHint = 10;
		gd.widthHint = 100;
		progressBar = new ProgressBar(parent, SWT.INDETERMINATE);
		progressBar.setLayoutData(gd);
		progressBar.setVisible(false);

		reportLocationText.addModifyListener(new ModifyListener() {

			public void modifyText(ModifyEvent e) {
				//
			}

		});

		browseFolderButton.addSelectionListener(new SelectionAdapter() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				setButtonEnable(false);
				FileDialog dialog = new FileDialog(reportLocationText
						.getShell());
				String[] extension = { "*.rptdesign" };
				dialog.setFilterExtensions(extension);
				if (reportLocationText.getText() != null
						&& reportLocationText.getText().trim().length() > 0) {

					dialog.setFilterPath(reportLocationText.getText());

				}

				String selectedLocation = dialog.open();
				if (selectedLocation != null) {
					reportLocationText.setText(selectedLocation);
				}
				setButtonEnable(true);
			}

		});

		browser.addLocationListener(new LocationAdapter() {

			public void changed(final LocationEvent e) {
				progressBar.setVisible(false);
			}

			public void changing(final LocationEvent e) {
				progressBar.setVisible(true);
			}
		});

		showReportButton.addSelectionListener(new SelectionListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {

				setPreView();

				// addReportParameters(lParent, gridData);
				// openReportRunner();

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});
		htmlOutputButton.addSelectionListener(new SelectionListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				progressBar.setVisible(true);
				setButtonEnable(false);
				try {

					setReportFile(HTML_OUT);
				} catch (Exception exp) {
					exp.printStackTrace();
					MessageDialog.openError(getSite().getShell(),
							"Abort output HTML", exp.getMessage());
				} finally {
					setButtonEnable(true);
					progressBar.setVisible(false);
				}

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});

		pdfOutputButton.addSelectionListener(new SelectionListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetSelected(SelectionEvent e) {
				progressBar.setVisible(true);
				setButtonEnable(false);
				try {

					setReportFile(PDF_OUT);
				} catch (Exception exp) {
					exp.printStackTrace();
					MessageDialog.openError(getSite().getShell(),
							"Abort output PDF", exp.getMessage());

				} finally {
					setButtonEnable(true);
					progressBar.setVisible(false);
				}

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});

	}

	protected void setReportFile(int selectNo) throws EngineException,
			FileNotFoundException, IOException, Exception {
		String reportFileName = reportLocationText.getText();

		String outputFileRenderOption = "";
		if (selectNo != PREVIEW) {

			String fileName = "*";
			String fileExt = "";
			switch (selectNo) {
			case HTML_OUT:
				fileExt = "*.html";
				fileName = fileName + ".html";
				break;
			case PDF_OUT:
				fileExt = "*.pdf";
				fileName = fileName + ".pdf";
				break;
			default:
				break;
			}

			outputFileRenderOption = setOutputFileDialog(fileName, fileExt);
		}

		previewReport(selectNo, reportFileName, outputFileRenderOption);
	}


	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}
}
