package netjfwatcher.birt.model;

import java.util.logging.Logger;

import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;

/**
 * ReportEngine𐶐NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ReportEngineFactory {
	private static IReportEngine engine;

	// MO
	private static Logger logger = null;

	// RXgN^privateɂĕspӂɒڃRXgN^Ăяoh~
	private ReportEngineFactory() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/**
	 * ReportEngine𐶐܂B
	 * 
	 * @return engine ReportEngine
	 */
	public IReportEngine createReportEngine() {
		EngineConfig config = new EngineConfig();

		// Create the report engine
		IReportEngineFactory factory = (IReportEngineFactory) Platform
				.createFactoryObject(IReportEngineFactory.EXTENSION_REPORT_ENGINE_FACTORY);
		engine = factory.createReportEngine(config);
		engine.changeLogLevel(java.util.logging.Level.WARNING);

		return engine;
	}

	/**
	 * ReportEnginej܂B
	 * 
	 */
	protected void finalize() throws java.lang.Throwable {

		super.finalize();
		if (engine != null) {
			engine.destroy();
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ReportEngineFactory getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ReportEngineFactory RESOURCE = new ReportEngineFactory();
	}
}
