/*
 * Created on 2006/08/25
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.birt.preference;

import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;




/**
 * The main plugin class to be used in the desktop.
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetWatcherRCPBirtPlugin extends AbstractUIPlugin {
    //The shared instance.
    private static NetWatcherRCPBirtPlugin plugin;

    /* ResourceBundle */
    private ResourceBundle resourceBundle;

    /**
     * The constructor.
     */
    public NetWatcherRCPBirtPlugin() {
        plugin = this;
    }

    /**
     * UIPluginCX^XԂ܂B
     *
     * @return instance NetWatchRCPJettyPlugin
     */
    public static NetWatcherRCPBirtPlugin getInstance() {
        return plugin;
    }

    /**
     * Returns the plugin's resource bundle,
     *
     * @return resourceBundle ResourceBundle
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    /**
     * This method is called upon plug-in activation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    /**
     * Returns the shared instance.
     */
    public static NetWatcherRCPBirtPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns an image descriptor for the image file at the given
     * plug-in relative path.
     *
     * @param path the path
     * @return the image descriptor
     */
    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin(
            "NetWatcherRCPBIRT", path);
    }
}
