/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.logging.Logger;
import netjfwatcher.syslogng.receive.AbstractSyslogNGReciveParse;

public class SyslogNGTCPReceiveParseThread
extends AbstractSyslogNGReciveParse
implements Runnable {
    private static Logger logger = null;
    private Thread thisThread;
    private Socket syslogNGReceiveSocket;
    private InputStream inputStream;

    protected SyslogNGTCPReceiveParseThread(boolean isSetAlarm, String ignoreMessage, Socket socket) throws IOException {
        logger = Logger.getLogger(this.getClass().getName());
        this.setIgnoreMessage(ignoreMessage);
        this.isSetAlarm = isSetAlarm;
        this.syslogNGReceiveSocket = socket;
        this.inputStream = this.syslogNGReceiveSocket.getInputStream();
    }

    public void startSyslogNGParseThread(String remoteIP, int port) {
        this.remoteip = remoteIP;
        this.port = port;
        this.thisThread = Thread.currentThread();
        this.thisThread.setName(this.thisThread + " : " + remoteIP);
        this.thisThread = new Thread(this);
        this.thisThread.setName(this.thisThread + " : " + remoteIP);
        logger.info("syslog-NG parse thread start : " + this.thisThread + " Remote IP=" + remoteIP + " Port=" + this.syslogNGReceiveSocket.getPort());
        this.thisThread.start();
    }

    public void run() {
        Thread curThread = Thread.currentThread();
        curThread.setName(curThread + " : " + this.remoteip);
        try {
            try {
                while (true) {
                    this.parseReceiveData();
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                logger.warning("InterruptedException " + ex.getMessage());
            }
            catch (IOException ex) {
                logger.info("InterruptedException " + ex.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.warning("Exception " + ex.getMessage());
            }
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
                this.inputStream = null;
            }
            if (this.syslogNGReceiveSocket != null) {
                try {
                    this.syslogNGReceiveSocket.close();
                    this.syslogNGReceiveSocket = null;
                }
                catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    private void parseReceiveData() throws IOException {
        this.receiveDataByte = new byte[8192];
        this.receiveLength = this.inputStream.read(this.receiveDataByte);
        this.setSyslogNGReceiveData("tcp/" + this.port);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.syslogNGReceiveSocket != null) {
            try {
                this.syslogNGReceiveSocket.close();
                this.syslogNGReceiveSocket = null;
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
    }
}

