/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.syslogng.receive.AbstractSyslogNGServer;
import netjfwatcher.syslogng.receive.SyslogNGTCPReceiveParseThread;

public final class SyslogNGTCPReceiveServer
extends AbstractSyslogNGServer
implements Runnable {
    private static Logger logger = null;
    private ServerSocket syslogNGReceiveServer;
    private List socketList = Collections.synchronizedList(new LinkedList());

    private SyslogNGTCPReceiveServer() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static SyslogNGTCPReceiveServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void startSyslogNGReceiveServer(boolean isSetAlarm, String ignoreMessage) throws IOException {
        this.isSetAlarm = isSetAlarm;
        this.ignoreMessage = ignoreMessage;
        this.syslogNGReceiveServer = new ServerSocket(this.tcpPort);
        logger.info("Create server socket : " + this.syslogNGReceiveServer.getLocalPort());
        this.syslogNGReceiveParseThread = new Thread(SingletonResource.RESOURCE);
        this.syslogNGReceiveParseThread.setDaemon(true);
        this.syslogNGReceiveParseThread.start();
    }

    public void stopSyslogNGReceiveServer() {
        if (this.syslogNGReceiveParseThread == null) {
            return;
        }
        this.syslogNGReceiveParseThread.interrupt();
        if (this.syslogNGReceiveServer != null) {
            try {
                this.syslogNGReceiveServer.close();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            while (this.syslogNGReceiveParseThread != null && this.syslogNGReceiveParseThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.syslogNGReceiveServer = null;
        }
        logger.info("Syslog-NG receive thread stop");
        this.syslogNGReceiveParseThread = null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                while (true) {
                    socket = this.syslogNGReceiveServer.accept();
                    SyslogNGTCPReceiveServer.logger.info("Accept Address : " + socket.getInetAddress().getHostAddress() + " : port :" + socket.getLocalPort());
                    SyslogNGTCPReceiveServer.logger.info("allowHost : " + this.allowHost);
                    socket.setKeepAlive(true);
                    remoteIPAddress = socket.getInetAddress().getHostAddress();
                    SyslogNGTCPReceiveServer.logger.info("Connect remote IP Address : " + remoteIPAddress);
                    isAllowClient = this.checkHost(this.allowHost, remoteIPAddress);
                    if (!isAllowClient) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            SyslogNGTCPReceiveServer.logger.warning("Reject socket close error" + e.getMessage());
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.socketList.add(socket);
                    SyslogNGTCPReceiveServer.logger.info("Client address = " + socket.getLocalSocketAddress());
                    SyslogNGTCPReceiveServer.logger.info("Client port = " + socket.getLocalPort());
                    parseThread = new SyslogNGTCPReceiveParseThread(this.isSetAlarm, this.ignoreMessage, socket);
                    parseThread.startSyslogNGParseThread(remoteIPAddress, this.tcpPort);
                }
            }
            catch (IOException ex) {
                if (this.syslogNGReceiveServer.isClosed()) {
                    SyslogNGTCPReceiveServer.logger.info("Server socket closed " + ex.getMessage());
                }
                SyslogNGTCPReceiveServer.logger.warning(ex.getMessage());
            }
        }
        finally {
            i = 0;
            ** while (i < this.socketList.size())
        }
lbl-1000:
        // 1 sources

        {
            var7_13 = (Socket)this.socketList.get(i);
            try {
                SyslogNGTCPReceiveServer.logger.info("Closed socket = " + i);
                var7_13.close();
            }
            catch (IOException e) {
                SyslogNGTCPReceiveServer.logger.warning(e.getMessage());
                e.printStackTrace();
            }
            ++i;
            continue;
        }
lbl45:
        // 1 sources

        this.socketList.clear();
        if (this.syslogNGReceiveServer == null) return;
        try {
            this.syslogNGReceiveServer.close();
            return;
        }
        catch (IOException e) {
            SyslogNGTCPReceiveServer.logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.syslogNGReceiveServer != null) {
            this.syslogNGReceiveServer.close();
        }
    }

    /* synthetic */ SyslogNGTCPReceiveServer(SyslogNGTCPReceiveServer syslogNGTCPReceiveServer) {
        this();
    }

    private static class SingletonResource {
        static final SyslogNGTCPReceiveServer RESOURCE = new SyslogNGTCPReceiveServer(null);

        private SingletonResource() {
        }
    }
}

