/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.syslogng.receive.AbstractSyslogNGServer;
import netjfwatcher.syslogng.receive.SyslogNGUDPReceiveParseThread;

public final class SyslogNGUDPReceiveServer
extends AbstractSyslogNGServer
implements Runnable {
    private static Logger logger = null;
    private DatagramSocket syslogNGReceiveDatagramSocket;
    private List socketList = Collections.synchronizedList(new LinkedList());

    private SyslogNGUDPReceiveServer() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public static SyslogNGUDPReceiveServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void startSyslogNGReceiveServer(boolean isSetAlarm, String ignoreMessage) throws IOException {
        this.isSetAlarm = isSetAlarm;
        this.ignoreMessage = ignoreMessage;
        this.syslogNGReceiveDatagramSocket = new DatagramSocket(this.udpPort);
        logger.info("Create server socket : " + this.syslogNGReceiveDatagramSocket.getLocalPort());
        this.syslogNGReceiveParseThread = new Thread(SingletonResource.RESOURCE);
        this.syslogNGReceiveParseThread.setDaemon(true);
        this.syslogNGReceiveParseThread.start();
    }

    public void stopSyslogNGReceiveServer() {
        if (this.syslogNGReceiveParseThread == null) {
            return;
        }
        this.syslogNGReceiveParseThread.interrupt();
        if (this.syslogNGReceiveDatagramSocket != null) {
            this.syslogNGReceiveDatagramSocket.close();
            while (this.syslogNGReceiveParseThread != null && this.syslogNGReceiveParseThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.syslogNGReceiveDatagramSocket = null;
        }
        logger.info("Syslog-NG receive thread stop");
        this.syslogNGReceiveParseThread = null;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        try {
            try {
                while (true) {
                    receiveBuffer = new byte[8192];
                    receivePacket = new DatagramPacket(receiveBuffer, 8192);
                    this.syslogNGReceiveDatagramSocket.receive(receivePacket);
                    receiveLength = receivePacket.getLength();
                    if (receiveLength <= 0) continue;
                    test = receivePacket.getSocketAddress().toString().split(":");
                    SyslogNGUDPReceiveServer.logger.info("Remote IP Address=" + receivePacket.getSocketAddress());
                    remoteIPAddress = test[0].substring(1, test[0].length());
                    isAllowClient = this.checkHost(this.allowHost, remoteIPAddress);
                    if (!isAllowClient) {
                        this.syslogNGReceiveDatagramSocket.close();
                        continue;
                    }
                    receiveDataByte = receivePacket.getData();
                    parseThread = new SyslogNGUDPReceiveParseThread(this.isSetAlarm, this.ignoreMessage);
                    parseThread.startSyslogNGParseThread(remoteIPAddress, this.udpPort, receivePacket, receiveDataByte, receiveLength);
                }
            }
            catch (IOException ex) {
                if (this.syslogNGReceiveDatagramSocket.isClosed()) {
                    SyslogNGUDPReceiveServer.logger.info("Server socket closed " + ex.getMessage());
                }
                SyslogNGUDPReceiveServer.logger.warning(ex.getMessage());
            }
        }
        finally {
            i = 0;
            ** while (i < this.socketList.size())
        }
lbl-1000:
        // 1 sources

        {
            var11_14 = (Socket)this.socketList.get(i);
            try {
                SyslogNGUDPReceiveServer.logger.info("Closed socket = " + i);
                var11_14.close();
            }
            catch (IOException e) {
                SyslogNGUDPReceiveServer.logger.warning(e.getMessage());
                e.printStackTrace();
            }
            ++i;
            continue;
        }
lbl39:
        // 1 sources

        this.socketList.clear();
        if (this.syslogNGReceiveDatagramSocket != null) {
            this.syslogNGReceiveDatagramSocket.close();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.syslogNGReceiveDatagramSocket != null) {
            this.syslogNGReceiveDatagramSocket.close();
        }
    }

    /* synthetic */ SyslogNGUDPReceiveServer(SyslogNGUDPReceiveServer syslogNGUDPReceiveServer) {
        this();
    }

    private static class SingletonResource {
        static final SyslogNGUDPReceiveServer RESOURCE = new SyslogNGUDPReceiveServer(null);

        private SingletonResource() {
        }
    }
}

