/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.syslogng.plugin.NetJFWatcherRCPSyslogNGPlugin;
import netjfwatcher.syslogng.resource.SyslogNGConfInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;

public class SyslogNGResourceFileParse {
    public static final String XML_FILE_VALUE = "value";
    public static final String CONF = "conf";
    public static final String ALLOW_HOST = "allow-host";
    public static final String TCP_PORT = "tcp-port";
    public static final String UDP_PORT = "udp-port";
    private SyslogNGConfInfo syslogNGConf;
    private String allowHost;
    private String tcpPort;
    private String udpPort;
    private static Logger logger = null;

    public SyslogNGResourceFileParse() throws Exception {
        logger = Logger.getLogger(this.getClass().getName());
        this.syslogNGConf = SyslogNGConfInfo.getInstance();
        logger.info("Resource File Parse : resources/syslogng_conf.xml");
        Document doc = null;
        doc = this.getDocument("resources/syslogng_conf.xml");
        if (doc == null) {
            logger.severe("Resource File Doc null ");
            return;
        }
        Element root = doc.getRootElement();
        if (root.getChild(ALLOW_HOST) != null) {
            this.allowHost = root.getChild(ALLOW_HOST).getAttributeValue(XML_FILE_VALUE);
            this.syslogNGConf.setAllowHost(this.allowHost);
        }
        if (root.getChild(TCP_PORT) != null) {
            this.tcpPort = root.getChild(TCP_PORT).getAttributeValue(XML_FILE_VALUE);
            this.syslogNGConf.setTcpPort(this.tcpPort);
        }
        if (root.getChild(UDP_PORT) != null) {
            this.udpPort = root.getChild(UDP_PORT).getAttributeValue(XML_FILE_VALUE);
            this.syslogNGConf.setUdpPort(this.udpPort);
        }
        logger.info("allowHost " + this.allowHost);
        logger.info("tcpPort " + this.tcpPort);
        logger.info("udpPort " + this.udpPort);
    }

    public Document getResourceFileDocumentPath(String file) {
        Document doc = null;
        File f = new File(file);
        if (f == null) {
            logger.warning("Abort create File : " + f.getAbsolutePath());
            return null;
        }
        BufferedReader d = null;
        try {
            FileReader fi = new FileReader(file);
            d = new BufferedReader(fi);
        }
        catch (FileNotFoundException e1) {
            logger.warning("FileNotFoundException : " + f.getPath() + " : " + e1.getMessage());
            logger.warning("FileNotFoundException : " + f.getAbsolutePath() + " : " + e1.getMessage());
            e1.printStackTrace();
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((Reader)d);
        }
        catch (JDOMException e) {
            logger.warning("JDOMException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.warning("NullPointerException : " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.warning("IOException : " + e.getMessage());
            e.printStackTrace();
        }
        return doc;
    }

    protected Document getDocument(String file) {
        URL url;
        Document doc;
        block5: {
            doc = null;
            url = null;
            logger.severe("Parse start : " + file);
            Bundle bundle = NetJFWatcherRCPSyslogNGPlugin.getInstance().getBundle();
            url = bundle.getEntry(file);
            if (url != null) break block5;
            logger.severe("Resource XML file url : " + url);
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        }
        catch (JDOMException e) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
            e.printStackTrace();
        }
        return doc;
    }

    public SyslogNGConfInfo getSyslogNGConf() {
        return this.syslogNGConf;
    }
}

