/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.view;

import java.io.IOException;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.syslogng.receive.SyslogNGTCPReceiveServer;
import netjfwatcher.syslogng.receive.SyslogNGUDPReceiveServer;
import netjfwatcher.syslogng.resource.SyslogNGConfInfo;
import netjfwatcher.syslogng.resource.SyslogNGResourceConfig;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class SyslogNGReceiveControlView
extends ViewPart {
    private SubStatusLineManager statusLineManager;
    private static final String TCP_START = "tcp start";
    private static final String TCP_STOP = "tcp stop";
    private static final String UDP_START = "udp start";
    private static final String UDP_STOP = "udp stop";
    private static final String TCP_IGNORE_MESSAGE = "STATS,Connection broken,reopening,Error connecting,reattempting";
    private static final String UDP_IGNORE_MESSAGE = "STATS,Connection broken,reopening,Error connecting,reattempting";
    private static final int IGNORE_MESSAGE_TEXT_WIDTH = 500;
    private static final int TEXT_WIDTH = 200;
    private static final int PORT_TEXT_WIDTH = 120;
    private static final int HORIZONTAL_SPAN2 = 2;
    private static final int HORIZONTAL_SPAN3 = 3;
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{800, 200};
    private Text allowHostText;
    private Text tcpIgnoreMessageText;
    private Text udpIgnoreMessageText;
    private Text syslogNGTCPPortText;
    private Text syslogNGUDPPortText;
    private Button tcpReceiveStartButton;
    private Button tcpReceiveStopButton;
    private Button udpReceiveStartButton;
    private Button udpReceiveStopButton;
    private Button tcpAlarmCheckButton;
    private Button udpAlarmCheckButton;
    protected Color textBackColor;
    private SyslogNGConfInfo syslogNGConf;

    public SyslogNGReceiveControlView() {
        SyslogNGResourceConfig.getInstance().getResourceFileParse().getSyslogNGConf();
    }

    public void createPartControl(Composite parent) {
        this.setStatusLine();
        this.textBackColor = Display.getCurrent().getSystemColor(1);
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 0);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData(256));
        GridData gridData = null;
        GridLayout gridLayout2 = new GridLayout(6, false);
        Composite composite2 = new Composite(baseComposite, 0);
        composite2.setLayoutData((Object)new GridData(256));
        composite2.setLayout((Layout)gridLayout2);
        Label label = new Label(composite2, 0);
        label.setText("TCP Port");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.syslogNGTCPPortText = new Text(composite2, 133128);
        this.syslogNGTCPPortText.setText("");
        this.syslogNGTCPPortText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.syslogNGTCPPortText.setBackground(this.textBackColor);
        this.syslogNGTCPPortText.setLayoutData((Object)gridData);
        this.tcpReceiveStartButton = new Button(composite2, 0);
        this.tcpReceiveStartButton.setText(TCP_START);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.tcpReceiveStartButton.setLayoutData((Object)gridData);
        this.tcpReceiveStopButton = new Button(composite2, 0);
        this.tcpReceiveStopButton.setText(TCP_STOP);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.tcpReceiveStopButton.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite2, 0);
        label.setText("UDP Port");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.syslogNGUDPPortText = new Text(composite2, 133128);
        this.syslogNGUDPPortText.setText("");
        this.syslogNGUDPPortText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.syslogNGUDPPortText.setBackground(this.textBackColor);
        this.syslogNGUDPPortText.setLayoutData((Object)gridData);
        this.udpReceiveStartButton = new Button(composite2, 0);
        this.udpReceiveStartButton.setText(UDP_START);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.udpReceiveStartButton.setLayoutData((Object)gridData);
        this.udpReceiveStopButton = new Button(composite2, 0);
        this.udpReceiveStopButton.setText(UDP_STOP);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.udpReceiveStopButton.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(baseComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        label = new Label(composite, 0);
        label.setText("Allow-Host");
        label.setLayoutData((Object)new GridData());
        this.allowHostText = new Text(composite, 2056);
        this.allowHostText.setText("");
        this.allowHostText.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.allowHostText.setBackground(this.textBackColor);
        this.allowHostText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.tcpAlarmCheckButton = new Button(composite, 32);
        this.tcpAlarmCheckButton.setText("TCP Receive Set Alarm");
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("TCP Receive Ignore Message");
        label.setLayoutData((Object)new GridData());
        this.tcpIgnoreMessageText = new Text(composite, 2048);
        this.tcpIgnoreMessageText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 500;
        this.tcpIgnoreMessageText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.udpAlarmCheckButton = new Button(composite, 32);
        this.udpAlarmCheckButton.setText("UDP Receive Set Alarm");
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("UDP Receive Ignore Message");
        label.setLayoutData((Object)new GridData());
        this.udpIgnoreMessageText = new Text(composite, 2048);
        this.udpIgnoreMessageText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 500;
        this.udpIgnoreMessageText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setInitText();
        this.tcpReceiveStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SyslogNGReceiveControlView.this.tcpAlarmCheckButton.getSelection() && !DatabaseControl.getInstance().isDatabaseStart()) {
                    MessageDialog.openError((Shell)SyslogNGReceiveControlView.this.getSite().getShell(), (String)"Error", (String)"Not running Database.");
                    SyslogNGReceiveControlView.this.tcpAlarmCheckButton.setSelection(false);
                }
                SyslogNGReceiveControlView.this.tcpReceiveStartButton.setEnabled(false);
                SyslogNGReceiveControlView.this.tcpReceiveStopButton.setEnabled(true);
                SyslogNGReceiveControlView.this.tcpIgnoreMessageText.setEnabled(false);
                SyslogNGReceiveControlView.this.tcpAlarmCheckButton.setEnabled(false);
                try {
                    SyslogNGTCPReceiveServer.getInstance().startSyslogNGReceiveServer(SyslogNGReceiveControlView.this.tcpAlarmCheckButton.getSelection(), SyslogNGReceiveControlView.this.tcpIgnoreMessageText.getText());
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)SyslogNGReceiveControlView.this.getSite().getShell(), (String)"Error", (String)("Abort TCP Server start. " + e.getMessage()));
                    SyslogNGReceiveControlView.this.tcpReceiveStartButton.setEnabled(true);
                    SyslogNGReceiveControlView.this.tcpReceiveStopButton.setEnabled(false);
                    SyslogNGReceiveControlView.this.tcpIgnoreMessageText.setEnabled(true);
                    SyslogNGReceiveControlView.this.tcpAlarmCheckButton.setEnabled(true);
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.tcpReceiveStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SyslogNGReceiveControlView.this.tcpReceiveStopButton.setEnabled(false);
                SyslogNGTCPReceiveServer.getInstance().stopSyslogNGReceiveServer();
                SyslogNGReceiveControlView.this.tcpReceiveStartButton.setEnabled(true);
                SyslogNGReceiveControlView.this.tcpIgnoreMessageText.setEnabled(true);
                SyslogNGReceiveControlView.this.tcpAlarmCheckButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.udpReceiveStartButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (SyslogNGReceiveControlView.this.udpAlarmCheckButton.getSelection() && !DatabaseControl.getInstance().isDatabaseStart()) {
                    MessageDialog.openError((Shell)SyslogNGReceiveControlView.this.getSite().getShell(), (String)"Error", (String)"Not running Database.");
                    SyslogNGReceiveControlView.this.udpAlarmCheckButton.setSelection(false);
                }
                SyslogNGReceiveControlView.this.udpReceiveStartButton.setEnabled(false);
                SyslogNGReceiveControlView.this.udpReceiveStopButton.setEnabled(true);
                SyslogNGReceiveControlView.this.udpIgnoreMessageText.setEnabled(false);
                SyslogNGReceiveControlView.this.udpAlarmCheckButton.setEnabled(false);
                try {
                    SyslogNGUDPReceiveServer.getInstance().startSyslogNGReceiveServer(SyslogNGReceiveControlView.this.udpAlarmCheckButton.getSelection(), SyslogNGReceiveControlView.this.udpIgnoreMessageText.getText());
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)SyslogNGReceiveControlView.this.getSite().getShell(), (String)"Error", (String)("Abort UDP Server start. " + e.getMessage()));
                    SyslogNGReceiveControlView.this.udpReceiveStartButton.setEnabled(true);
                    SyslogNGReceiveControlView.this.udpReceiveStopButton.setEnabled(false);
                    SyslogNGReceiveControlView.this.udpIgnoreMessageText.setEnabled(true);
                    SyslogNGReceiveControlView.this.udpAlarmCheckButton.setEnabled(true);
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.udpReceiveStopButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                SyslogNGReceiveControlView.this.udpReceiveStopButton.setEnabled(false);
                SyslogNGUDPReceiveServer.getInstance().stopSyslogNGReceiveServer();
                SyslogNGReceiveControlView.this.udpReceiveStartButton.setEnabled(true);
                SyslogNGReceiveControlView.this.udpIgnoreMessageText.setEnabled(true);
                SyslogNGReceiveControlView.this.udpAlarmCheckButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void setInitText() {
        this.tcpReceiveStopButton.setEnabled(false);
        this.udpReceiveStopButton.setEnabled(false);
        this.syslogNGConf = SyslogNGConfInfo.getInstance();
        this.allowHostText.setText(this.syslogNGConf.getAllowHost());
        this.tcpAlarmCheckButton.setSelection(true);
        this.udpAlarmCheckButton.setSelection(true);
        this.tcpIgnoreMessageText.setText("STATS,Connection broken,reopening,Error connecting,reattempting");
        this.udpIgnoreMessageText.setText("STATS,Connection broken,reopening,Error connecting,reattempting");
        this.syslogNGTCPPortText.setText(this.syslogNGConf.getTcpPort());
        this.syslogNGUDPPortText.setText(this.syslogNGConf.getUdpPort());
        if (SyslogNGTCPReceiveServer.getInstance().getSyslogNGReceiveParseThread() != null && SyslogNGTCPReceiveServer.getInstance().getSyslogNGReceiveParseThread().isAlive()) {
            this.tcpReceiveStopButton.setEnabled(true);
            this.tcpReceiveStartButton.setEnabled(false);
        }
        if (SyslogNGUDPReceiveServer.getInstance().getSyslogNGReceiveParseThread() != null && SyslogNGUDPReceiveServer.getInstance().getSyslogNGReceiveParseThread().isAlive()) {
            this.udpReceiveStopButton.setEnabled(true);
            this.udpReceiveStartButton.setEnabled(false);
        }
    }

    protected void setStatusLine() {
    }

    public void setFocus() {
    }
}

