/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.syslogng.view.table;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.syslogng.actions.ActionBuilderSyslogReceiveTable;
import netjfwatcher.syslogng.view.SyslogNGTimerProcessor;
import netjfwatcher.syslogng.view.table.SyslogNGReceiveTableViewContentProvider;
import netjfwatcher.syslogng.view.table.SyslogNGReceiveTableViewLabelProvider;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class SyslogNGReceiveTableView
extends AbstractTableView {
    private ActionBuilderSyslogReceiveTable actionSyslogReceiveTableBuilder;
    private static boolean isCol0Direction = false;
    private static boolean isCol1Direction = true;
    private static boolean isCol2Direction = true;
    private static boolean isCol3Direction = true;
    private static boolean isCol4Direction = true;
    private TableColumn col0;
    private TableColumn col1;
    private TableColumn col2;
    private TableColumn col3;
    private TableColumn col4;
    private static final float COLUMN0NO = 0.03f;
    private static final float COLUMN1DATE = 0.1f;
    private static final float COLUMN2HOST = 0.1f;
    private static final float COLUMN3PORT = 0.1f;
    private static final float COLUMN4MSG = 0.5f;
    private Table table;
    private TableViewer viewer;
    private SyslogNGTimerProcessor timerProcessor;
    private SubStatusLineManager statusLineManager;
    private Display display;

    public ActionBuilderSyslogReceiveTable getActionBuilder() {
        return this.actionSyslogReceiveTableBuilder;
    }

    public void setFocus() {
        this.setStatusLine();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new SyslogNGReceiveTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SyslogNGReceiveTableViewLabelProvider());
        this.actionSyslogReceiveTableBuilder = new ActionBuilderSyslogReceiveTable(this.display, this.table, this.viewer);
        this.createContextMenu();
        this.initActions();
        this.startTimer();
    }

    private int computeCol0Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.03f);
    }

    private int computeCol1Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol2Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol3Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.1f);
    }

    private int computeCol4Width() {
        return (int)((float)this.getSite().getShell().getSize().x * 0.5f);
    }

    private void createTable(Composite parent) {
        this.setStatusLine();
        this.table = new Table(parent, 66304);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 4));
        this.col0 = new TableColumn(this.table, 16384);
        this.col0.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[0]);
        this.col0.setWidth(this.computeCol0Width());
        this.col1 = new TableColumn(this.table, 16384);
        this.col1.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[1]);
        this.col1.setWidth(this.computeCol1Width());
        this.col2 = new TableColumn(this.table, 16384);
        this.col2.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[2]);
        this.col2.setWidth(this.computeCol2Width());
        this.col3 = new TableColumn(this.table, 16384);
        this.col3.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[3]);
        this.col3.setWidth(this.computeCol3Width());
        this.col4 = new TableColumn(this.table, 16384);
        this.col4.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[4]);
        this.col4.setWidth(this.computeCol4Width());
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                SyslogNGReceiveTableView.this.setResizedTableColumnWidth();
            }
        });
        this.col0.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol0Direction = SyslogNGReceiveTableView.this.sortIntegerTable(SyslogNGReceiveTableView.this.table, 0, isCol0Direction);
            }
        });
        this.col1.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol1Direction = SyslogNGReceiveTableView.this.sortTable(SyslogNGReceiveTableView.this.table, 1, isCol1Direction);
            }
        });
        this.col2.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol2Direction = SyslogNGReceiveTableView.this.sortTable(SyslogNGReceiveTableView.this.table, 2, isCol2Direction);
            }
        });
        this.col3.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol3Direction = SyslogNGReceiveTableView.this.sortTable(SyslogNGReceiveTableView.this.table, 3, isCol3Direction);
            }
        });
        this.col4.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                isCol4Direction = SyslogNGReceiveTableView.this.sortTable(SyslogNGReceiveTableView.this.table, 4, isCol4Direction);
            }
        });
    }

    protected void setResizedTableColumnWidth() {
        if (this.getSite().getPage().isPartVisible(this.getSite().getPart()) && this.getSite().getShell() != null && this.getSite().getShell().getSize() != null) {
            this.col0.setWidth(this.computeCol0Width());
            this.col1.setWidth(this.computeCol1Width());
            this.col2.setWidth(this.computeCol2Width());
            this.col3.setWidth(this.computeCol3Width());
            this.col4.setWidth(this.computeCol4Width());
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.getActionBuilder().getActionResetSyslogTable());
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SyslogNGReceiveTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    private void initActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.getActionBuilder().getActionResetSyslogTable());
    }

    private void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(true);
    }

    private void startTimer() {
        SyslogNGTimerProcessor.getInstance().setDisplay(this.display);
        SyslogNGTimerProcessor.getInstance().setTable(this.table);
        this.timerProcessor = SyslogNGTimerProcessor.getInstance();
        this.display.timerExec(1000, (Runnable)this.timerProcessor);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.display.timerExec(-1, (Runnable)this.timerProcessor);
    }
}

