/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.perspective;

import netjfwatcher.syslogng.view.SyslogNGReceiveControlView;
import netjfwatcher.syslogng.view.table.SyslogNGReceiveTableView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * syslog-ng PerspectiveNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SyslogNGPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.syslogng.perspective.SyslogNGPerspective";

	private static final float SYSLOG_NG_CONTROL_RATIO = 0.40f;

	private static final float SYSLOG_NG_TABLE_RATIO = 0.60f;

	/**
	 * PerspectivȅCAEgs܂B
	 * 
	 * @param layout
	 *            IPageLayout
	 */
	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(false);

		String editorArea = layout.getEditorArea();

		IFolderLayout top = layout.createFolder("top", IPageLayout.TOP,
				SYSLOG_NG_CONTROL_RATIO, editorArea);
		top.addView(SyslogNGReceiveControlView.class.getName());

		IFolderLayout bottom = layout.createFolder("bottom",
				IPageLayout.BOTTOM, SYSLOG_NG_TABLE_RATIO, editorArea);
		bottom.addView(SyslogNGReceiveTableView.class.getName());

	}
}
