/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.syslogng.receive.data.SyslogNGDataInfo;
import netjfwatcher.syslogng.receive.data.SyslogNGDataQueue;

public abstract class AbstractSyslogNGReciveParse extends DataStringDisplay {

	protected static final int SLEEP_TIME = 1000;

	// obt@TCY
	protected static final int RECEIVE_BUFF_SIZE = 8192;

	protected boolean isSetAlarm;

	protected String ignoreMessage;

	protected DateFormat dateformat = new SimpleDateFormat(
			"yyyy-MM-dd HH:mm:ss");

	protected String remoteip;

	protected int port;

	protected int receiveLength;

	protected byte[] receiveDataByte;

	protected String[] ignoreMessageItem;

	protected void setIgnoreMessage(String ignoreMessage) {
		this.ignoreMessage = ignoreMessage;
		Pattern pattern;
		pattern = Pattern.compile(",");
		ignoreMessageItem = pattern.split(ignoreMessage);
	}

	protected void setSyslogNGReceiveData(String portInfo) {

		if (receiveLength <= 0) {
			return;
		}

		/*
		 * System.out.println("Buffer Receive Data : " +
		 * hexBytetoString(receiveDataByte, receiveLength));
		 * 
		 * System.out.println("Buffer Receive Data : " +
		 * bytetoChar(receiveDataByte, receiveLength));
		 */

		String message = bytetoChar(receiveDataByte, receiveLength);
		Date date = java.util.Calendar.getInstance().getTime();

		Pattern pattern;
		String[] messageItem;

		pattern = Pattern.compile("[\n]"); // s
		messageItem = pattern.split(message);

		for (int i = 0; i < messageItem.length; i++) {

			SyslogNGDataInfo syslogNGInfo = new SyslogNGDataInfo();

			syslogNGInfo.setReceiveDate(dateformat.format(date));
			syslogNGInfo.setReceiveHost(remoteip);
			syslogNGInfo.setPortInfo(portInfo);
			syslogNGInfo.setReceiveMessage(messageItem[i]);

			SyslogNGDataQueue.getInstance().pushSyslogNGDataQueue(syslogNGInfo);
			if (isSetAlarm) {
				/* AlarmƂ镶񂪊܂܂Ă邩`FbN */
				if (messageItem[i] != null && !messageItem[i].equals("")
						&& ignoreMessageItem != null) {
					boolean isHitIgnoreMsg = false;
					for (int j = 0; j < ignoreMessageItem.length; j++) {
						// System.out.println(j + " : " + ignoreMessageItem[j]);
						if (ignoreMessageItem[j] != null) {
							if (messageItem[i].indexOf(ignoreMessageItem[j]) >= 0) {
								isHitIgnoreMsg = true;
								break;
							}
						}
					}

					if (!isHitIgnoreMsg) {
						AlarmMessageMake alarmMessageMakeInstance = AlarmMessageMake
								.getInstance();
						alarmMessageMakeInstance.setSyslogNG(remoteip,
								portInfo + " : " + messageItem[i]);

					}
				}
			}
		}
	}
}
