/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

/**
 * syslog-ngTCPŎMT[oNNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SyslogNGTCPReceiveServer extends AbstractSyslogNGServer
		implements Runnable {
	// MO
	private static Logger logger = null;

	/* ServerSocket */
	private ServerSocket syslogNGReceiveServer;

	private List socketList = Collections.synchronizedList(new LinkedList());

	/**
	 * RXgN^privateɂĕspӂɒڃRXgN^ Ăяoh~
	 */
	private SyslogNGTCPReceiveServer() {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SyslogNGTCPReceiveServer getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * syslog-ng Socketڑ҂Socket\Pbg𐶐Aslslog-ngM҂XbhJn܂B<BR>
	 * 
	 * @throws IOException
	 *             ServerSocketɎsꍇ
	 */
	public void startSyslogNGReceiveServer(boolean isSetAlarm,
			String ignoreMessage) throws IOException {

		this.isSetAlarm = isSetAlarm;
		this.ignoreMessage = ignoreMessage;

		syslogNGReceiveServer = new ServerSocket(tcpPort);
		logger.info("Create server socket : "
				+ syslogNGReceiveServer.getLocalPort());

		syslogNGReceiveParseThread = new Thread(SingletonResource.RESOURCE);
		syslogNGReceiveParseThread.setDaemon(true);
		syslogNGReceiveParseThread.start();
	}

	public void stopSyslogNGReceiveServer() {
		if (syslogNGReceiveParseThread == null) {
			return;
		}

		// interrupt receive thread so it will die a natural death
		syslogNGReceiveParseThread.interrupt();

		if (syslogNGReceiveServer != null) {
			try {
				syslogNGReceiveServer.close();
			} catch (IOException e1) {
				logger.warning(e1.getMessage());
				e1.printStackTrace();
			}

			/* Thread~܂Loop */
			while ((syslogNGReceiveParseThread != null)
					&& syslogNGReceiveParseThread.isAlive()) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			syslogNGReceiveServer = null;
		}

		logger.info("Syslog-NG receive thread stop");
		syslogNGReceiveParseThread = null;
	}


	public void run() {
		try {
			while (true) {
				// ڑΎ󂯓
				Socket socket = syslogNGReceiveServer.accept();

				logger.info("Accept Address : "
						+ socket.getInetAddress().getHostAddress()
						+ " : port :" + socket.getLocalPort());
				logger.info("allowHost : " + allowHost);
				socket.setKeepAlive(true);

				// ڑIP Address
				String remoteIPAddress = socket.getInetAddress()
						.getHostAddress();
				logger.info("Connect remote IP Address : " + remoteIPAddress);

				/*
				 * ڑClientł邩`FbN
				 */
				boolean isAllowClient = checkHost(allowHost, remoteIPAddress);

				if (!isAllowClient) {
					/* Client ڑ */
					try {
						socket.close();
					} catch (IOException e) {
						logger.warning("Reject socket close error"
								+ e.getMessage());
						e.printStackTrace();
					}
				} else {
					/*
					 * Clientڑ󂯓 󂯓ꂽڑpXbh𐶐EJn Local IP Addressy PORT
					 */
					socketList.add(socket);

					logger.info("Client address = "
							+ socket.getLocalSocketAddress());
					logger.info("Client port = " + socket.getLocalPort());

					SyslogNGTCPReceiveParseThread parseThread = new SyslogNGTCPReceiveParseThread(
							isSetAlarm, ignoreMessage, socket);
					parseThread.startSyslogNGParseThread(remoteIPAddress,
							tcpPort);
				}
			} // Client̐ڑ҂[v
		} catch (IOException ex) {
			/*
			 * Clientڑ҂Shutdown(퓮)yыN ُȂǂُ̈̏ꍇ
			 * (Client̐ؒfɂExceptionThreadőΉ)
			 */
			if (syslogNGReceiveServer.isClosed()) {
				logger.info("Server socket closed " + ex.getMessage());
			} else {
				logger.warning(ex.getMessage());
			}
		} finally {
			for (int i = 0; i < socketList.size(); i++) {
				Socket test = (Socket) socketList.get(i);

				try {
					logger.info("Closed socket = " + i);
					test.close();
				} catch (IOException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}

			socketList.clear();

			if (syslogNGReceiveServer != null) {
				try {
					syslogNGReceiveServer.close();
				} catch (IOException e) {
					logger.warning(e.getMessage());
					e.printStackTrace();
				}
			}
		}
	}



	/**
	 * ServerSocketN[Y܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (syslogNGReceiveServer != null) {
			syslogNGReceiveServer.close();
		}
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SyslogNGTCPReceiveServer RESOURCE = new SyslogNGTCPReceiveServer();
	}
}
