/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Logger;

public class SyslogNGUDPReceiveParseThread extends AbstractSyslogNGReciveParse
		implements Runnable {

	/* MO */
	private static Logger logger = null;

	/* ClientƂ̐ڑThread */
	private Thread thisThread;


	protected SyslogNGUDPReceiveParseThread(boolean isSetAlarm, String ignoreMessage) throws IOException {
		super();
		logger = Logger.getLogger(this.getClass().getName());
		setIgnoreMessage(ignoreMessage);
		this.isSetAlarm = isSetAlarm;
	}

	/**
	 * NCAgւ̃CxgPUSHʒmp̃XbhJn܂B<BR>
	 * iNCAg̐ڑ҂[vĂ΂܂j<BR>
	 * 
	 * @param remoteIP
	 *            NCAgIPAhX
	 */
	public void startSyslogNGParseThread(final String remoteIP, final int port, DatagramPacket receivePacket,
			byte[] receiveDataByte, int receiveLength) {

		remoteip = remoteIP;
		this.port = port;
		this.receiveDataByte = receiveDataByte;
		this.receiveLength = receiveLength;
		thisThread = Thread.currentThread();
		thisThread.setName(thisThread + " : " + remoteip);

		thisThread = new Thread(this);
		thisThread.setName(thisThread + " : " + remoteip);

		thisThread.start();
	}

	/**
	 * NCAgւ̃CxgPUSHʒmp̃XbhłB<BR>
	 * ؒf܂Ŗ[vœ삵܂B
	 * 
	 */
	public void run() {
		Thread curThread = Thread.currentThread();
		curThread.setName(curThread + " : " + remoteip);

		this.setSyslogNGReceiveData("udp/" + port);

	}

	/**
	 * SocketN[Y܂B
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

	}

}
