/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.receive.data;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;


/**
 * syslog-ngMThreadsyslog-nge[u\ThreadԂ̃f[^̂߂
 * L[\NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class SyslogNGDataQueue {
    /* L[Xg */
    private static List syslogNGDataQueueList;

    /* L[l */
    private static final int QUEUE_LIMIT = 1000;

    /* L[Ɋi[邩ۂtO */
    private boolean isMonitor = true;

    /**
     * Snmp}l[WɂG[WFg̃f[^MThread
     * SNMP}l[We[u\ThreadԂ̃f[^̂߂
     * L[\NXCX^X𐶐܂B
     *
     */
    private SyslogNGDataQueue() {
        syslogNGDataQueueList = Collections.synchronizedList(new LinkedList());
    }

    /**
     * L[ɃbZ[Wi[܂B
     *
     * @param obj L[Ɋi[郁bZ[W
     */
    public synchronized void pushSyslogNGDataQueue(SyslogNGDataInfo obj) {
        if (isMonitor) {
            if (syslogNGDataQueueList.size() > QUEUE_LIMIT) {
                syslogNGDataQueueList.remove(0);
                syslogNGDataQueueList.add(obj);
            } else {
                syslogNGDataQueueList.add(obj);
            }
        }
    }

    /**
     * L[syslog-ngPop܂B
     *
     * @return syslogNGData syslog-ng
     */
    public synchronized SyslogNGDataInfo popSyslogNGDataQueue() {
    	SyslogNGDataInfo syslogNGData = null;

        if (syslogNGDataQueueList.size() > 0) {
        	syslogNGData = (SyslogNGDataInfo)syslogNGDataQueueList.get(0);
            syslogNGDataQueueList.remove(0);
        }

        return syslogNGData;
    }

    /**
     * L[Objecti[邩ۂtOZbg܂B
     *
     * @param isMonitor L[Objecti[邩ۂtO
     */
    public void setMonitor(boolean isMonitor) {
        syslogNGDataQueueList.clear();
        this.isMonitor = isMonitor;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SyslogNGDataQueue getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SyslogNGDataQueue RESOURCE = new SyslogNGDataQueue();
    }

	public static List getSyslogNGDataQueueList() {
		return syslogNGDataQueueList;
	}
}
