/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.view;

import java.io.IOException;

import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.syslogng.receive.SyslogNGTCPReceiveServer;
import netjfwatcher.syslogng.receive.SyslogNGUDPReceiveServer;
import netjfwatcher.syslogng.resource.SyslogNGConfInfo;
import netjfwatcher.syslogng.resource.SyslogNGResourceConfig;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

/**
 * syslog-ngM\` ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SyslogNGReceiveControlView extends ViewPart {
	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	private static final String TCP_START = "tcp start";

	private static final String TCP_STOP = "tcp stop";

	private static final String UDP_START = "udp start";

	private static final String UDP_STOP = "udp stop";

	private static final String TCP_IGNORE_MESSAGE = "STATS,Connection broken,reopening,Error connecting,reattempting";

	private static final String UDP_IGNORE_MESSAGE = "STATS,Connection broken,reopening,Error connecting,reattempting";

	private static final int IGNORE_MESSAGE_TEXT_WIDTH = 500;

	private static final int TEXT_WIDTH = 200;

	private static final int PORT_TEXT_WIDTH = 120;

	private static final int HORIZONTAL_SPAN2 = 2;

	private static final int HORIZONTAL_SPAN3 = 3;

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 200 };

	private Text allowHostText;

	private Text tcpIgnoreMessageText;

	private Text udpIgnoreMessageText;

	private Text syslogNGTCPPortText;

	private Text syslogNGUDPPortText;

	private Button tcpReceiveStartButton;

	private Button tcpReceiveStopButton;

	private Button udpReceiveStartButton;

	private Button udpReceiveStopButton;

	private Button tcpAlarmCheckButton;

	private Button udpAlarmCheckButton;

	/** m[heLXg\BackGroundFi[ */
	protected Color textBackColor;

	private SyslogNGConfInfo syslogNGConf;

	public SyslogNGReceiveControlView() {
		SyslogNGResourceConfig.getInstance().getResourceFileParse()
				.getSyslogNGConf();
	}

	/**
	 * PartControl𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* Xe[^XC\Zbg */
		setStatusLine();

		/* textwiFZbg */
		textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite baseComposite = new Composite(scrollComposite, SWT.NULL);

		baseComposite.setLayout(gridLayout0);
		baseComposite
				.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));

		GridData gridData = null;

		GridLayout gridLayout2 = new GridLayout(6, false);
		Composite composite2 = new Composite(baseComposite, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		Label label = new Label(composite2, SWT.NONE);
		label.setText("TCP Port");
		gridData = new GridData();
		label.setLayoutData(gridData);

		syslogNGTCPPortText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY
				| SWT.RIGHT);
		syslogNGTCPPortText.setText("");
		syslogNGTCPPortText.setEnabled(false);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = PORT_TEXT_WIDTH;
		syslogNGTCPPortText.setBackground(textBackColor);
		syslogNGTCPPortText.setLayoutData(gridData);

		tcpReceiveStartButton = new Button(composite2, SWT.NONE);
		tcpReceiveStartButton.setText(TCP_START);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		tcpReceiveStartButton.setLayoutData(gridData);

		tcpReceiveStopButton = new Button(composite2, SWT.NONE);
		tcpReceiveStopButton.setText(TCP_STOP);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		tcpReceiveStopButton.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("UDP Port");
		gridData = new GridData();
		label.setLayoutData(gridData);

		syslogNGUDPPortText = new Text(composite2, SWT.BORDER | SWT.READ_ONLY
				| SWT.RIGHT);
		syslogNGUDPPortText.setText("");
		syslogNGUDPPortText.setEnabled(false);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = PORT_TEXT_WIDTH;
		syslogNGUDPPortText.setBackground(textBackColor);
		syslogNGUDPPortText.setLayoutData(gridData);

		udpReceiveStartButton = new Button(composite2, SWT.NONE);
		udpReceiveStartButton.setText(UDP_START);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		udpReceiveStartButton.setLayoutData(gridData);

		udpReceiveStopButton = new Button(composite2, SWT.NONE);
		udpReceiveStopButton.setText(UDP_STOP);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		udpReceiveStopButton.setLayoutData(gridData);

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite = new Composite(baseComposite, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		label = new Label(composite, SWT.NONE);
		label.setText("Allow-Host");
		label.setLayoutData(new GridData());
		allowHostText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
		allowHostText.setText("");
		allowHostText.setEnabled(false);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		allowHostText.setBackground(textBackColor);
		allowHostText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		tcpAlarmCheckButton = new Button(composite, SWT.CHECK);
		tcpAlarmCheckButton.setText("TCP Receive Set Alarm");

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("TCP Receive Ignore Message");
		label.setLayoutData(new GridData());
		tcpIgnoreMessageText = new Text(composite, SWT.BORDER);
		tcpIgnoreMessageText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = IGNORE_MESSAGE_TEXT_WIDTH;
		tcpIgnoreMessageText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		udpAlarmCheckButton = new Button(composite, SWT.CHECK);
		udpAlarmCheckButton.setText("UDP Receive Set Alarm");

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("UDP Receive Ignore Message");
		label.setLayoutData(new GridData());
		udpIgnoreMessageText = new Text(composite, SWT.BORDER);
		udpIgnoreMessageText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = IGNORE_MESSAGE_TEXT_WIDTH;
		udpIgnoreMessageText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		scrollComposite.setContent(baseComposite);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setInitText();

		tcpReceiveStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (tcpAlarmCheckButton.getSelection()) {
					if (!DatabaseControl.getInstance().isDatabaseStart()) {
						MessageDialog.openError(getSite().getShell(), "Error",
								"Not running Database.");
						tcpAlarmCheckButton.setSelection(false);
					}
				}
				tcpReceiveStartButton.setEnabled(false);
				tcpReceiveStopButton.setEnabled(true);
				tcpIgnoreMessageText.setEnabled(false);
				tcpAlarmCheckButton.setEnabled(false);
				try {

					SyslogNGTCPReceiveServer.getInstance()
							.startSyslogNGReceiveServer(
									tcpAlarmCheckButton.getSelection(),
									tcpIgnoreMessageText.getText());

				} catch (IOException e) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Abort TCP Server start. " + e.getMessage());
					tcpReceiveStartButton.setEnabled(true);
					tcpReceiveStopButton.setEnabled(false);
					tcpIgnoreMessageText.setEnabled(true);
					tcpAlarmCheckButton.setEnabled(true);
					e.printStackTrace();
				}

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		tcpReceiveStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				tcpReceiveStopButton.setEnabled(false);

				SyslogNGTCPReceiveServer.getInstance()
						.stopSyslogNGReceiveServer();

				tcpReceiveStartButton.setEnabled(true);
				tcpIgnoreMessageText.setEnabled(true);
				tcpAlarmCheckButton.setEnabled(true);
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		udpReceiveStartButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				if (udpAlarmCheckButton.getSelection()) {
					if (!DatabaseControl.getInstance().isDatabaseStart()) {
						MessageDialog.openError(getSite().getShell(), "Error",
								"Not running Database.");
						udpAlarmCheckButton.setSelection(false);
					}
				}
				udpReceiveStartButton.setEnabled(false);
				udpReceiveStopButton.setEnabled(true);
				udpIgnoreMessageText.setEnabled(false);
				udpAlarmCheckButton.setEnabled(false);
				try {
					SyslogNGUDPReceiveServer.getInstance()
							.startSyslogNGReceiveServer(
									udpAlarmCheckButton.getSelection(),
									udpIgnoreMessageText.getText());

				} catch (IOException e) {
					MessageDialog.openError(getSite().getShell(), "Error",
							"Abort UDP Server start. " + e.getMessage());
					udpReceiveStartButton.setEnabled(true);
					udpReceiveStopButton.setEnabled(false);
					udpIgnoreMessageText.setEnabled(true);
					udpAlarmCheckButton.setEnabled(true);
					e.printStackTrace();
				}

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
		udpReceiveStopButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {

				udpReceiveStopButton.setEnabled(false);

				SyslogNGUDPReceiveServer.getInstance()
						.stopSyslogNGReceiveServer();

				udpReceiveStartButton.setEnabled(true);
				udpIgnoreMessageText.setEnabled(true);
				udpAlarmCheckButton.setEnabled(true);

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.swt.events.
			 *      SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

	}

	private void setInitText() {
		tcpReceiveStopButton.setEnabled(false);
		udpReceiveStopButton.setEnabled(false);
		syslogNGConf = SyslogNGConfInfo.getInstance();
		allowHostText.setText(syslogNGConf.getAllowHost());
		tcpAlarmCheckButton.setSelection(true);
		udpAlarmCheckButton.setSelection(true);
		tcpIgnoreMessageText.setText(TCP_IGNORE_MESSAGE);
		udpIgnoreMessageText.setText(UDP_IGNORE_MESSAGE);
		syslogNGTCPPortText.setText(syslogNGConf.getTcpPort());
		syslogNGUDPPortText.setText(syslogNGConf.getUdpPort());
		if (SyslogNGTCPReceiveServer.getInstance()
				.getSyslogNGReceiveParseThread() != null
				&& SyslogNGTCPReceiveServer.getInstance()
						.getSyslogNGReceiveParseThread().isAlive()) {
			tcpReceiveStopButton.setEnabled(true);
			tcpReceiveStartButton.setEnabled(false);

		}
		if (SyslogNGUDPReceiveServer.getInstance()
				.getSyslogNGReceiveParseThread() != null
				&& SyslogNGUDPReceiveServer.getInstance()
						.getSyslogNGReceiveParseThread().isAlive()) {
			udpReceiveStopButton.setEnabled(true);
			udpReceiveStartButton.setEnabled(false);
		}
	}

	/**
	 * Xe[^XCZbg܂B
	 * 
	 */
	protected void setStatusLine() {

	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}
}
