/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.view;

import java.util.List;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.syslogng.receive.data.SyslogNGDataInfo;
import netjfwatcher.syslogng.receive.data.SyslogNGDataQueue;
import netjfwatcher.syslogng.view.table.SyslogNGReceiveTableViewLabelProvider;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/**
 * syslog-ngMf[^i[L[IɊĎAe[u\NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SyslogNGTimerProcessor extends AbstractTableView implements
		Runnable {
	/** syslog-ngML[Ď(ms) */
	public static final int TIMER = 1000;

	/** Timer~R[h */
	public static final int TIMER_STOP = -1;

	private static int count = 0;

	/* Display */
	private Display display;

	/* syslog-ngMf[^\e[u */
	private Table syslogTable;

	/*
	 * syslog-ngMf[^i[L[IɊĎAe[u\ NXCX^X𐶐܂B
	 */
	private SyslogNGTimerProcessor() {
		// nothing
	}

	/**
	 * syslog-ngML[IɊĎAL[Ƀf[^ꍇɂ f[^Popsyslog-ngMe[uɕ\܂B
	 * 
	 */
	public void run() {

		List syslogNGDataQueueList = (List) SyslogNGDataQueue.getInstance()
				.getSyslogNGDataQueueList();

		while (syslogNGDataQueueList != null
				&& syslogNGDataQueueList.size() != 0) {
			SyslogNGDataInfo syslogNGInfo = SyslogNGDataQueue.getInstance()
					.popSyslogNGDataQueue();

			String[] syslogInfoStringArray = new String[SyslogNGReceiveTableViewLabelProvider.SYSLOG_ARRAY_COUNT];
			count++;
			syslogInfoStringArray[SyslogNGReceiveTableViewLabelProvider.SYSLOG_NO_POS] = Integer
					.toString(count);
			syslogInfoStringArray[SyslogNGReceiveTableViewLabelProvider.SYSLOG_DATE_POS] = syslogNGInfo
					.getReceiveDate();
			syslogInfoStringArray[SyslogNGReceiveTableViewLabelProvider.SYSLOG_HOST_POS] = syslogNGInfo
					.getReceiveHost();
			syslogInfoStringArray[SyslogNGReceiveTableViewLabelProvider.SYSLOG_PORT_POS] = syslogNGInfo
					.getPortInfo();
			syslogInfoStringArray[SyslogNGReceiveTableViewLabelProvider.SYSLOG_MSG_POS] = syslogNGInfo
					.getReceiveMessage();
			/*
			 * syslog-ngMe[usɃf[^ǉE\
			 */
			TableItem tableItem = new TableItem(syslogTable, SWT.NULL);
			tableItem.setData(syslogInfoStringArray);
			tableItem.setText(syslogInfoStringArray);

			syslogNGDataQueueList = (List) SyslogNGDataQueue.getInstance()
					.getSyslogNGDataQueueList();
			if (syslogNGDataQueueList.size() == 0) {
				/* syslog-ngMe[uJ0Ń\[g\ */
				sortIntegerTable(syslogTable, 0, true);
			}

		}

		// ^C}[p
		display.timerExec(TIMER, this);
	}
	protected void setResizedTableColumnWidth() {
	}
	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SyslogNGTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display) {
		this.display = display;
	}

	/**
	 * XVe[uZbg܂B
	 * 
	 * @param table
	 *            XVe[u
	 */
	public void setTable(Table table) {
		this.syslogTable = table;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SyslogNGTimerProcessor RESOURCE = new SyslogNGTimerProcessor();
	}
}
