/*
 * Created on 2006/10/10
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.syslogng.view.table;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import netjfwatcher.syslogng.actions.ActionBuilderSyslogReceiveTable;
import netjfwatcher.syslogng.view.SyslogNGTimerProcessor;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * syslog-ngM\e[uView\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SyslogNGReceiveTableView extends AbstractTableView {

	/* syslog-ngMe[uANVNXCX^X */
	private ActionBuilderSyslogReceiveTable actionSyslogReceiveTableBuilder;

	/**
	 * ANV\z܂B
	 * 
	 * @return actionBuilder ActionBuilder
	 */
	public ActionBuilderSyslogReceiveTable getActionBuilder() {
		return actionSyslogReceiveTableBuilder;
	}

	/* e[u\\[gɂJ0̃ftHg̃\[g */
	private static boolean isCol0Direction = false;

	/* e[u\\[gɂJ1̃ftHg̃\[g */
	private static boolean isCol1Direction = true;

	/* e[u\\[gɂJ2̃ftHg̃\[g */
	private static boolean isCol2Direction = true;

	/* e[u\\[gɂJ3̃ftHg̃\[g */
	private static boolean isCol3Direction = true;

	/* e[u\\[gɂJ3̃ftHg̃\[g */
	private static boolean isCol4Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	/* J */
	private static final float COLUMN0NO = 0.03f;

	private static final float COLUMN1DATE = 0.1f;

	private static final float COLUMN2HOST = 0.1f;

	private static final float COLUMN3PORT = 0.1f;

	private static final float COLUMN4MSG = 0.5f;

	/* syslog-ngMe[u */
	private Table table;

	/* syslog-ngMTableViewer */
	private TableViewer viewer;

	/* syslog-ngMe[uTimer */
	private SyslogNGTimerProcessor timerProcessor;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* Display */
	private Display display;

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
		setStatusLine();
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();

		/* TrapMe[u𐶐 */
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer
				.setContentProvider(new SyslogNGReceiveTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new SyslogNGReceiveTableViewLabelProvider());

		/* ANV\z */
		actionSyslogReceiveTableBuilder = new ActionBuilderSyslogReceiveTable(
				display, table, viewer);

		/* ReLXgj[AZbg */
		createContextMenu();

		/* ANV̏ */
		initActions();

		startTimer();
	}

	/**
	 * J0iNo.j̕Ԃ܂B
	 * 
	 * @return J0iNo.j̕
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0NO);
	}

	/**
	 * J1iDatej̕Ԃ܂B
	 * 
	 * @return J1iDatej̕
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1DATE);
	}

	/**
	 * J2iHostj̕Ԃ܂B
	 * 
	 * @return J2iHostj̕
	 */
	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2HOST);
	}

	/**
	 * J3iPortj̕Ԃ܂B
	 * 
	 * @return J3iPortj̕
	 */
	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3PORT);
	}

	/**
	 * J4iMessagej̕Ԃ܂B
	 * 
	 * @return J4iMessagej̕
	 */
	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4MSG);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	private void createTable(Composite parent) {
		setStatusLine();

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		/*
		 * TableōsNbNꂽꍇ̃Xi[Zbg
		 */
		table.addSelectionListener(new TableColumnControlTableListener(table,
				SyslogNGReceiveTableViewLabelProvider.SYSLOG_MSG_POS));

		/*
		 * e[uJ0(No.)Zbg
		 */
		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[SyslogNGReceiveTableViewLabelProvider.SYSLOG_NO_POS]);
		col0.setWidth(computeCol0Width());

		/*
		 * e[uJ1(Date)Zbg
		 */
		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[SyslogNGReceiveTableViewLabelProvider.SYSLOG_DATE_POS]);
		col1.setWidth(computeCol1Width());

		/*
		 * e[uJ2(Host)Zbg
		 */
		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[SyslogNGReceiveTableViewLabelProvider.SYSLOG_HOST_POS]);
		col2.setWidth(computeCol2Width());

		/*
		 * e[uJ3(Port)Zbg
		 */
		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[SyslogNGReceiveTableViewLabelProvider.SYSLOG_PORT_POS]);
		col3.setWidth(computeCol3Width());
		/*
		 * e[uJ4(Message)Zbg
		 */
		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(SyslogNGReceiveTableViewLabelProvider.COLUMNS[SyslogNGReceiveTableViewLabelProvider.SYSLOG_MSG_POS]);
		col4.setWidth(computeCol4Width());

		/**
		 * e[uړyуTCỸXi[
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.swt.events.
					 *      ControlListener#controlMoved(org.eclipse.swt.events.ControlEvent)
					 */
					public void controlMoved(ControlEvent event) {
					}

					/**
					 * e[uResizedŃJĐݒ肵܂B
					 */
					public void controlResized(ControlEvent event) {
						setResizedTableColumnWidth();

					}
				});

		/**
		 * J0(No.)wb_[ClickXi[ƂāAe[u \\[g܂B
		 * 
		 */
		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table,
						SyslogNGReceiveTableViewLabelProvider.SYSLOG_NO_POS,
						isCol0Direction);
			}
		});

		/**
		 * J1(Date)wb_[ClickXi[ƂāAe[ u\\[g܂B
		 * 
		 */
		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol1Direction = sortTable(table,
						SyslogNGReceiveTableViewLabelProvider.SYSLOG_DATE_POS,
						isCol1Direction);
			}
		});

		/**
		 * J2(Host)wb_[ClickXi[ƂāA e[u\\[g܂B
		 * 
		 */
		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol2Direction = sortTable(table,
						SyslogNGReceiveTableViewLabelProvider.SYSLOG_HOST_POS,
						isCol2Direction);
			}
		});

		/**
		 * J3(Port)wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol3Direction = sortTable(table,
						SyslogNGReceiveTableViewLabelProvider.SYSLOG_PORT_POS,
						isCol3Direction);
			}
		});

		/**
		 * J4(Message)wb_[ClickXi[ƂāAe[u\\[g܂B
		 * 
		 */
		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event e) {
				isCol4Direction = sortTable(table,
						SyslogNGReceiveTableViewLabelProvider.SYSLOG_MSG_POS,
						isCol4Direction);
			}
		});

	}

	protected void setResizedTableColumnWidth() {
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());

			}
		}

	}

	/**
	 * syslog-ngMe[ũj[o[𐶐܂B preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(getActionBuilder().getActionResetSyslogTable());

	}

	/**
	 * syslog-ngMe[uContectj[𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/* ReLXgj[̐AZbg */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * syslog-ngMɊւANV̏s܂B
	 * 
	 */
	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		// syslog-ngMe[uNAANV
		toolBarManager.add(getActionBuilder().getActionResetSyslogTable());

	}

	/*
	 * Xe[^XC\s܂B TrapMThread̓Ԃ\܂B
	 */
	private void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

	}

	/*
	 * syslog-ngMf[^\^C}[̐Ass܂B
	 * 
	 */
	private void startTimer() {
		/* syslog-ngMf[^\^C}[̐As */
		SyslogNGTimerProcessor.getInstance().setDisplay(display);
		SyslogNGTimerProcessor.getInstance().setTable(table);
		timerProcessor = SyslogNGTimerProcessor.getInstance();
		display.timerExec(SyslogNGTimerProcessor.TIMER, timerProcessor);
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* syslog-ngMf[^\^C}[~ */
		display.timerExec(SyslogNGTimerProcessor.TIMER_STOP, timerProcessor);
	}
}
