/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUnderflowException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class BufferUtils {
    public static final Buffer EMPTY_BUFFER = BufferUtils.unmodifiableBuffer(new ArrayStack());

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return new SynchronizedBuffer(buffer){

            public synchronized boolean add(Object o) {
                boolean r = this.collection.add(o);
                this.notify();
                return r;
            }

            public synchronized boolean addAll(Collection c) {
                boolean r = this.collection.addAll(c);
                this.notifyAll();
                return r;
            }

            public synchronized Object get() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).get();
            }

            public synchronized Object remove() {
                while (this.collection.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new BufferUnderflowException();
                    }
                }
                return ((Buffer)this.collection).remove();
            }
        };
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return new UnmodifiableBuffer(buffer);
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return new PredicatedBuffer(buffer, predicate);
    }

    static class PredicatedBuffer
    extends CollectionUtils.PredicatedCollection
    implements Buffer {
        public PredicatedBuffer(Buffer b, Predicate p) {
            super(b, p);
        }

        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            return ((Buffer)this.collection).remove();
        }
    }

    static class UnmodifiableBuffer
    extends CollectionUtils.UnmodifiableCollection
    implements Buffer {
        public UnmodifiableBuffer(Buffer b) {
            super(b);
        }

        public Object get() {
            return ((Buffer)this.collection).get();
        }

        public Object remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class SynchronizedBuffer
    extends CollectionUtils.SynchronizedCollection
    implements Buffer {
        public SynchronizedBuffer(Buffer b) {
            super(b);
        }

        public synchronized Object get() {
            return ((Buffer)this.collection).get();
        }

        public synchronized Object remove() {
            return ((Buffer)this.collection).remove();
        }
    }
}

