/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.util.Random;

public class RandomStringUtils {
    private static final Random RANDOM = new Random();

    public static String random(int count) {
        return RandomStringUtils.random(count, false, false);
    }

    public static String randomAscii(int count) {
        return RandomStringUtils.random(count, 32, 127, false, false);
    }

    public static String randomAlphabetic(int count) {
        return RandomStringUtils.random(count, true, false);
    }

    public static String randomAlphanumeric(int count) {
        return RandomStringUtils.random(count, true, true);
    }

    public static String randomNumeric(int count) {
        return RandomStringUtils.random(count, false, true);
    }

    public static String random(int count, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count, 0, 0, letters, numbers);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers) {
        return RandomStringUtils.random(count, start, end, letters, numbers, null);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] set) {
        return RandomStringUtils.random(count, start, end, letters, numbers, set, RANDOM);
    }

    public static String random(int count, int start, int end, boolean letters, boolean numbers, char[] set, Random random) {
        if (start == 0 && end == 0) {
            end = 122;
            start = 32;
            if (!letters && !numbers) {
                start = 0;
                end = Integer.MAX_VALUE;
            }
        }
        StringBuffer buffer = new StringBuffer();
        int gap = end - start;
        while (count-- != 0) {
            char ch = set == null ? (char)(random.nextInt(gap) + start) : set[random.nextInt(gap) + start];
            if (letters && numbers && Character.isLetterOrDigit(ch) || letters && Character.isLetter(ch) || numbers && Character.isDigit(ch) || !letters && !numbers) {
                buffer.append(ch);
                continue;
            }
            ++count;
        }
        return buffer.toString();
    }

    public static String random(int count, String set) {
        return RandomStringUtils.random(count, set.toCharArray());
    }

    public static String random(int count, char[] set) {
        return RandomStringUtils.random(count, 0, set.length - 1, false, false, set);
    }
}

