/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.enum;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Enum
implements Comparable,
Serializable {
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap(0));
    private static final Map cEnumClasses = new HashMap();
    private final String iName;
    static /* synthetic */ Class class$org$apache$commons$lang$enum$Enum;
    static /* synthetic */ Class class$org$apache$commons$lang$enum$ValuedEnum;

    protected Enum(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The Enum name must not be empty or null");
        }
        this.iName = name;
        Class enumClass = Enum.getEnumClass(this.getClass());
        Entry entry = (Entry)cEnumClasses.get(enumClass);
        if (entry == null) {
            entry = Enum.createEntry(this.getClass());
            cEnumClasses.put(enumClass, entry);
        }
        if (entry.map.containsKey(name)) {
            throw new IllegalArgumentException("The Enum name must be unique, '" + name + "' has already been added");
        }
        entry.map.put(name, this);
        entry.list.add(this);
    }

    protected Object readResolve() {
        Entry entry = (Entry)cEnumClasses.get(Enum.getEnumClass(this.getClass()));
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(this.getName());
    }

    protected static Enum getEnum(Class enumClass, String name) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return null;
        }
        return (Enum)entry.map.get(name);
    }

    protected static Map getEnumMap(Class enumClass) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return EMPTY_MAP;
        }
        return Collections.unmodifiableMap(entry.map);
    }

    protected static List getEnumList(Class enumClass) {
        Entry entry = Enum.getEntry(enumClass);
        if (entry == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(entry.list);
    }

    protected static Iterator iterator(Class enumClass) {
        return Enum.getEnumList(enumClass).iterator();
    }

    private static Entry getEntry(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("The Enum Class must not be null");
        }
        if (!(class$org$apache$commons$lang$enum$Enum == null ? (class$org$apache$commons$lang$enum$Enum = Enum.class$("org.apache.commons.lang.enum.Enum")) : class$org$apache$commons$lang$enum$Enum).isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("The Class must be a subclass of Enum");
        }
        Entry entry = (Entry)cEnumClasses.get(enumClass);
        return entry;
    }

    private static Entry createEntry(Class enumClass) {
        Entry entry = new Entry();
        Class cls = enumClass.getSuperclass();
        while (cls != null && cls != (class$org$apache$commons$lang$enum$Enum == null ? Enum.class$("org.apache.commons.lang.enum.Enum") : class$org$apache$commons$lang$enum$Enum) && cls != (class$org$apache$commons$lang$enum$ValuedEnum == null ? Enum.class$("org.apache.commons.lang.enum.ValuedEnum") : class$org$apache$commons$lang$enum$ValuedEnum)) {
            Entry loopEntry = (Entry)cEnumClasses.get(cls);
            if (loopEntry != null) {
                entry.list.addAll(loopEntry.list);
                entry.map.putAll(loopEntry.map);
                break;
            }
            cls = cls.getSuperclass();
        }
        return entry;
    }

    protected static Class getEnumClass(Class cls) {
        String inner;
        String className = cls.getName();
        int index = className.lastIndexOf(36);
        if (index > -1 && (inner = className.substring(index + 1)).length() > 0 && inner.charAt(0) >= '0' && inner.charAt(0) < '9') {
            return cls.getSuperclass();
        }
        return cls;
    }

    public final String getName() {
        return this.iName;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() == this.getClass()) {
            return this.iName.equals(((Enum)other).iName);
        }
        if (Enum.getEnumClass(other.getClass()).getName().equals(Enum.getEnumClass(this.getClass()).getName())) {
            try {
                return this.iName.equals(((Enum)other).iName);
            }
            catch (ClassCastException ex) {
                try {
                    Method mth = other.getClass().getMethod("getName", null);
                    String name = (String)mth.invoke(other, null);
                    return this.iName.equals(name);
                }
                catch (NoSuchMethodException ex2) {
                }
                catch (IllegalAccessException ex2) {
                }
                catch (InvocationTargetException ex2) {
                    // empty catch block
                }
                return false;
            }
        }
        return false;
    }

    public final int hashCode() {
        return 7 + this.iName.hashCode();
    }

    public int compareTo(Object other) {
        return this.iName.compareTo(((Enum)other).iName);
    }

    public String toString() {
        String shortName = Enum.getEnumClass(this.getClass()).getName();
        int pos = shortName.lastIndexOf(46);
        if (pos != -1) {
            shortName = shortName.substring(pos + 1);
        }
        shortName = shortName.replace('$', '.');
        return shortName + "[" + this.getName() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Entry {
        final Map map = new HashMap();
        final List list = new ArrayList(25);

        private Entry() {
        }
    }
}

