/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.util;

import java.io.Serializable;
import java.util.Random;
import org.apache.commons.lang.functor.Factory;
import org.apache.commons.lang.functor.FactoryException;

public class IdentifierUtils {
    public static final Factory LONG_IDENTIFIER_FACTORY = new LongIdentifierFactory(true, 0L);
    public static final Factory STRING_NUMERIC_IDENTIFIER_FACTORY = new StringNumericIdentifierFactory(true, 0L);
    public static final Factory STRING_ALPHANUMERIC_IDENTIFIER_FACTORY = new StringAlphanumericIdentifierFactory(true, 15);
    public static final Factory STRING_SESSION_IDENTIFIER_FACTORY = new StringSessionIdentifierFactory();

    public static Long nextLongIdentifier() {
        return (Long)LONG_IDENTIFIER_FACTORY.create();
    }

    public static Factory longIdentifierFactory() {
        return new LongIdentifierFactory(true, 0L);
    }

    public static Factory longIdentifierFactory(boolean wrap, long initialValue) {
        return new LongIdentifierFactory(wrap, initialValue);
    }

    public static String nextStringNumericIdentifier() {
        return (String)STRING_NUMERIC_IDENTIFIER_FACTORY.create();
    }

    public static Factory stringNumericIdentifierFactory() {
        return new StringNumericIdentifierFactory(true, 0L);
    }

    public static Factory stringNumericIdentifierFactory(boolean wrap, long initialValue) {
        return new StringNumericIdentifierFactory(wrap, initialValue);
    }

    public static String nextStringAlphanumericIdentifier() {
        return (String)STRING_ALPHANUMERIC_IDENTIFIER_FACTORY.create();
    }

    public static Factory stringAlphanumericIdentifierFactory() {
        return new StringAlphanumericIdentifierFactory(true, 15);
    }

    public static Factory stringAlphanumericIdentifierFactory(boolean wrap, int size) {
        return new StringAlphanumericIdentifierFactory(wrap, size);
    }

    public static String nextStringSessionIdentifier() {
        return (String)STRING_SESSION_IDENTIFIER_FACTORY.create();
    }

    public static Factory stringSessionIdentifierFactory() {
        return new StringSessionIdentifierFactory();
    }

    private static class StringSessionIdentifierFactory
    implements Factory,
    Serializable {
        private static final long MAX_RANDOM_LEN = 2176782336L;
        private static final long MAX_TIME_SECTION_LEN = 46656L;
        private static final long TIC_DIFFERENCE = 2000L;
        private int counter = 0;
        private long lastTimeValue = 0L;
        private Random randomizer = new Random();

        private StringSessionIdentifierFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create() {
            long currentRandom = this.randomizer.nextLong();
            if (currentRandom < 0L) {
                currentRandom = -currentRandom;
            }
            currentRandom %= 2176782336L;
            currentRandom += 2176782336L;
            long currentTimeValue = 0L;
            int currentCount = 0;
            StringSessionIdentifierFactory stringSessionIdentifierFactory = this;
            synchronized (stringSessionIdentifierFactory) {
                currentTimeValue = System.currentTimeMillis() / 2000L;
                currentTimeValue %= 46656L;
                if (this.lastTimeValue != (currentTimeValue += 46656L)) {
                    this.lastTimeValue = currentTimeValue;
                    this.counter = 0;
                }
                currentCount = this.counter++;
            }
            StringBuffer id = new StringBuffer(15);
            id.append(Long.toString(currentRandom, 36).substring(1));
            id.append(Long.toString(currentTimeValue, 36).substring(1));
            id.append(Long.toString(currentCount, 36));
            return id.toString();
        }
    }

    private static class StringAlphanumericIdentifierFactory
    implements Factory,
    Serializable {
        private final boolean wrap;
        private char[] count = null;

        private StringAlphanumericIdentifierFactory(boolean wrap, int size) {
            this.wrap = wrap;
            if (size < 1) {
                throw new IllegalArgumentException("The size must be at least one");
            }
            this.count = new char[size];
            int i = 0;
            while (i < size) {
                this.count[i] = 48;
                ++i;
            }
        }

        public synchronized Object create() {
            int i = this.count.length - 1;
            while (i >= 0) {
                switch (this.count[i]) {
                    case 'z': {
                        this.count[i] = 48;
                        if (i != 0 || this.wrap) break;
                        throw new FactoryException("The maximum number of identifiers has been reached");
                    }
                    case '9': {
                        this.count[i] = 97;
                        i = -1;
                        break;
                    }
                    default: {
                        int n = i;
                        this.count[n] = (char)(this.count[n] + '\u0001');
                        i = -1;
                    }
                }
                --i;
            }
            return new String(this.count);
        }
    }

    private static class StringNumericIdentifierFactory
    implements Factory,
    Serializable {
        private final boolean wrap;
        private long count = 0L;

        private StringNumericIdentifierFactory(boolean wrap, long initialValue) {
            this.wrap = wrap;
            this.count = initialValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create() {
            long value = 0L;
            if (this.wrap) {
                StringNumericIdentifierFactory stringNumericIdentifierFactory = this;
                synchronized (stringNumericIdentifierFactory) {
                    value = this.count++;
                }
            }
            StringNumericIdentifierFactory stringNumericIdentifierFactory = this;
            synchronized (stringNumericIdentifierFactory) {
                if (this.count == Long.MAX_VALUE) {
                    throw new FactoryException("The maximum number of identifiers has been reached");
                }
                value = this.count++;
            }
            return Long.toString(value);
        }
    }

    private static class LongIdentifierFactory
    implements Factory,
    Serializable {
        private final boolean wrap;
        private long count = 0L;

        private LongIdentifierFactory(boolean wrap, long initialValue) {
            this.wrap = wrap;
            this.count = initialValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create() {
            long value = 0L;
            if (this.wrap) {
                LongIdentifierFactory longIdentifierFactory = this;
                synchronized (longIdentifierFactory) {
                    value = this.count++;
                }
            }
            LongIdentifierFactory longIdentifierFactory = this;
            synchronized (longIdentifierFactory) {
                if (this.count == Long.MAX_VALUE) {
                    throw new FactoryException("The maximum number of identifiers has been reached");
                }
                value = this.count++;
            }
            return new Long(value);
        }
    }
}

