/*
 * Created on 2004/05/09
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.confirm;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.alarm.confirm.model.AlarmConfirmModel;
import netjfwatcher.alarm.view.model.AlarmViewModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * SA[𖢊mFmFԂɂANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmAllConfirmAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            engineAddress = "all";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        // All Alarm Confirm
        AlarmConfirmModel alarmconfirmmodel = new AlarmConfirmModel();
        alarmconfirmmodel.updateAllAlarmConfirm(engineAddress, ipaddress);

        // Alarm View after alarm confirm
        AlarmViewModel alarmviewmodel =
            new AlarmViewModel(ipaddress, null, null);
        ArrayList alarmList =
            alarmviewmodel.getAlarmList(engineAddress, 0, 0, 0);

        request.setAttribute(Preference.ALARM_VIEW_LIST, alarmList);
        request.setAttribute(Preference.NODE_IPADDRESS, ipaddress);
        request.setAttribute(
            Preference.SORT_DIRECTION, Preference.SORT_DIR_DESC);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');

        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(
            Preference.FRAME_NAME_AT_SERVER_NAME, frameNameforServername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
