/*
 * Created on 2003/08/24
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.confirm.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionAlarmInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * GWɑSA[mF܂͌ʃA[mFʒm郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmConfirmModel {
    /* MO */
    private static Logger logger = null;

    /**
     * A[mFCX^X𐶐܂B
     *
     */
    public AlarmConfirmModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWɎw̃A[IDmFς݂Ƃʒms܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @param alarmID A[ID
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void updateAlarmConfirm(
        String engineAddress, String ipaddress, String alarmID)
        throws EngineConnectException, IOException {
        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();

                try {
                    ConnectionAlarmInformation connection =
                        new ConnectionAlarmInformation(testEngineAddress);
                    connection.confirmAlarmId(ipaddress, alarmID);
                } catch (EngineConnectException e) {
                    logger.info("Abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (IOException e) {
                    logger.info("Abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            ConnectionAlarmInformation connection =
                new ConnectionAlarmInformation(engineAddress);
            connection.confirmAlarmId(ipaddress, alarmID);
        }
    }

    /**
     * wm[h܂͑Sm[h̃A[mFς݂ƂʒmGWɍs܂B
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIPAhX
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void updateAllAlarmConfirm(String engineAddress, String ipaddress)
        throws EngineConnectException, IOException {
        /*
         * So^GWɑSA[mFς
         */
        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();

                try {
                    ConnectionAlarmInformation connection =
                        new ConnectionAlarmInformation(testEngineAddress);
                    connection.confirmAllAlarmt(ipaddress);
                } catch (EngineConnectException e) {
                    logger.info("Abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (IOException e) {
                    logger.info("Abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                }
            }
        } else {
            /*
             * wGW̑SAlarmmFς
             */
            ConnectionAlarmInformation connection =
                new ConnectionAlarmInformation(engineAddress);
            connection.confirmAllAlarmt(ipaddress);
        }
    }
}
