/*
 * Created on 2004/05/10
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * A[r[tB^[vANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewFilterPreSet extends Action {
    private static Logger logger = null;

    /**
     * NCAg̃^[QbgIPAhX𒆌pāAēxNCAgiAlarm FilterZbgj֕Ԃ܂B
     * iFlash̃p[^ƂĎgp܂j
     *
     * @param mapping ActionMapping
     * @param form ActionForm
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @return ActionForward
     * @throws Exception T[ubgňُ킪ꍇ
     */
    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "all";
        }

        InetAddress localAddress = InetAddress.getLocalHost();
        String servername = localAddress.getHostAddress();

        /*
         * Flash XMLSocketłlocalhostւ̐ڑłIPAhXł͂ȂlocalhostɂȂ
         * ڑłȂ
         */
        if (request.getRemoteAddr().equals("127.0.0.1")) {
            request.setAttribute(Preference.SERVER_NAME, "localhost");
        } else {
            request.setAttribute(Preference.SERVER_NAME, servername);
        }

        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward("success");
    }
}
