/*
 * Created on 2004/04/09
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * A[ƃA[ee[u\t[ZbgJSPփtH[hANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewFramesetAction extends Action {
    /* MO */
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        String alarmIndiPage = "1";
        int indiPage = 0;

        if (request.getParameter(Preference.ALARM_INDI_PAGE) != null) {
            alarmIndiPage = request.getParameter(Preference.ALARM_INDI_PAGE);
            indiPage =
                Integer.parseInt(
                    request.getParameter(Preference.ALARM_INDI_PAGE));
        }

        String alarmTotalPage = "1";

        if (request.getParameter(Preference.ALARM_TOTAL_PAGE) != null) {
            alarmTotalPage = request.getParameter(Preference.ALARM_TOTAL_PAGE);
        }

        if (request.getParameter(Preference.ALARM_PAGE_UP) != null) {
            if (indiPage < Integer.parseInt(alarmTotalPage)) {
                alarmIndiPage = Integer.toString(++indiPage);
            }
        }

        if (request.getParameter(Preference.ALARM_PAGE_DOWN) != null) {
            if (indiPage > 1) {
                alarmIndiPage = Integer.toString(--indiPage);
            }
        }

        String sortColumn = "";

        if (request.getParameter(Preference.SORT_COLUMN) != null) {
            sortColumn = request.getParameter(Preference.SORT_COLUMN);
        }

        String sortDirection = Preference.SORT_DIR_DESC;

        if (request.getParameter(Preference.SORT_DIRECTION) != null) {
            sortDirection = request.getParameter(Preference.SORT_DIRECTION);
        }

        String nodeIPAddress = request.getParameter(Preference.IPADDRESS);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        String convIPAddress = nodeIPAddress.replace('.', '_');

        /*
        logger.info("alarmIndiPage : " + alarmIndiPage);
        logger.info("alarmTotalPage : " + alarmTotalPage);
        */
        request.setAttribute(Preference.ALARM_INDI_PAGE, alarmIndiPage);
        request.setAttribute(Preference.ALARM_TOTAL_PAGE, alarmTotalPage);
        request.setAttribute(Preference.SORT_COLUMN, sortColumn);
        request.setAttribute(Preference.SORT_DIRECTION, sortDirection);
        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.NODE_IPADDRESS, nodeIPAddress);
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
