/*
 * Created on 2004/04/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * A[̃\[gsANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewSortAction extends Action {
    /* MO */
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);
        String sortColumn = request.getParameter(Preference.SORT_COLUMN);
        String sortDirection = request.getParameter(Preference.SORT_DIRECTION);

        String alarmIndiPage = "1";

        String alarmTotalPage = "1";

        if (request.getParameter(Preference.ALARM_TOTAL_PAGE) != null) {
            alarmTotalPage = request.getParameter(Preference.ALARM_TOTAL_PAGE);
        }

        int indiPage = 0;

        if (request.getParameter(Preference.ALARM_INDI_PAGE) != null) {
            alarmIndiPage = request.getParameter(Preference.ALARM_INDI_PAGE);
            indiPage =
                Integer.parseInt(
                    request.getParameter(Preference.ALARM_INDI_PAGE));
        }

        String convIPAddress = ipaddress.replace('.', '_');

        request.setAttribute(Preference.ALARM_INDI_PAGE, alarmIndiPage);
        request.setAttribute(Preference.ALARM_TOTAL_PAGE, alarmTotalPage);
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.NODE_IPADDRESS, ipaddress);
        request.setAttribute(Preference.SORT_DIRECTION, sortDirection);
        request.setAttribute(Preference.SORT_COLUMN, sortColumn);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String frameNameforServername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, frameNameforServername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
