/*
 * Created on 2004/12/25
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view.model;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.AlarmInformation;


/**
 * A[񃊃Xg̃\[gsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmListSort {
    /** e[u\[g  */
    public static final String SORT_DIRECTION_ASC = "asc";

    /**  e[u\[g~ */
    public static final String SORT_DIRECTION_DESC = "desc";

    /** A[mFԋLq */
    public static final String UNCONFIRM = "unconfirm";

    /** A[e[u A[IDJ */
    public static final String ALARM_ID = "id";

    /** A[e[u m[hJ */
    public static final String NODENAME = "nodename";

    /** A[e[u m[hO[vJ */
    public static final String GROUP = "node_group";

    /** A[e[u m[hIPAhXJ */
    public static final String IPADDRESS = "ipaddress";

    /** A[e[u A[R[hJ */
    public static final String ALARM_CODE = "alarm_code";

    /** A[e[u A[xJ */
    public static final String ALARM_LEVEL = "alarm_level";

    /** A[e[u A[bZ[WJ */
    public static final String ALARM_MESSAGE = "alarm_message";

    /** A[e[u A[mFJ */
    public static final String ALARM_CONFIRM = "alarm_confirm";

    /** A[e[u A[oJ */
    public static final String ALARM_DATE = "alarm_date";

    /* \[gΏۃJԍɏlݒ */
    private static String selectColumn = ALARM_DATE;

    /*
     * ܂͍~̂ꂩŃ\[gstOŃ\[gs
     * gOɔ]
     * l͏
     */
    private static String isOrderDirection = SORT_DIRECTION_ASC;

    /* Logging */
    private static Logger logger;

    public AlarmListSort() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * IuWFNgXg\[g܂B
     *
     * @param nodeInfoList \[gΏۃXg
     * @param _selectColumn \[gΏۃJ
     * @param _order \[g
     * @return nodeInfoList \[gʂ̃IuWFNgz
     */
    public ArrayList sortObjectArray(
        ArrayList nodeInfoList, final String _selectColumn, final String _order) {
        selectColumn = _selectColumn;
        isOrderDirection = _order;

        nodeInfoList = sortObjectArray(nodeInfoList);

        /* \[gʂԂ */
        return nodeInfoList;
    }

    /**
     * ɐݒς݂̃\[gɏ]āAe[ǔ^Ƀ\[g
     * s܂B<BR>
     *
     * @param nodeInfoList \[gΏۂ̃IuWFNgXg
     * @return nodeInfoList \[gs̃IuWFNgXg
     */
    public ArrayList sortObjectArray(ArrayList nodeInfoList) {
        /* ̏ꍇ̃\[g */
        nodeInfoList = sortString(nodeInfoList);

        return nodeInfoList;
    }

    /**
     *@^̃\[gs܂B<BR>
     *
     * @param datainfos \[gΏۂDataInfoIuWFNg̔z
     * @return datainfos \[gsDataInfoIuWFNg̔z
     */
    private ArrayList sortString(ArrayList nodeInfoList) {
        // logger.info("nodeInfoList.size() : " + nodeInfoList.size());
        for (int i = 0; i < (nodeInfoList.size() - 1); i++) {
            for (
                int checkPoint = nodeInfoList.size() - 1; checkPoint > i;
                    checkPoint--) {
                int resultCompareNumber = 0;
                AlarmInformation currentNodeInfo =
                    (AlarmInformation) nodeInfoList.get(checkPoint);
                AlarmInformation nextNodeInfo =
                    (AlarmInformation) nodeInfoList.get(checkPoint - 1);

                String currentinfo = "";
                String nextinfo = "";

                if (selectColumn.equals(ALARM_ID)) {
                    currentinfo = currentNodeInfo.getAlarmID();
                    nextinfo = nextNodeInfo.getAlarmID();

                    long currentValue = Integer.parseInt(currentinfo);
                    long nextValue = Integer.parseInt(nextinfo);

                    resultCompareNumber = (int) (currentValue - nextValue);
                    nodeInfoList =
                        swapRow(nodeInfoList, checkPoint, resultCompareNumber);

                    continue;
                } else if (selectColumn.equals(NODENAME)) {
                    currentinfo = currentNodeInfo.getNodename();
                    nextinfo = nextNodeInfo.getNodename();
                } else if (selectColumn.equals(IPADDRESS)) {
                    currentinfo = currentNodeInfo.getIpaddress();
                    nextinfo = nextNodeInfo.getIpaddress();
                } else if (selectColumn.equals(ALARM_CODE)) {
                    currentinfo = currentNodeInfo.getAlarmCode();
                    nextinfo = nextNodeInfo.getAlarmCode();
                } else if (selectColumn.equals(ALARM_LEVEL)) {
                    currentinfo = currentNodeInfo.getAlarmLevel();
                    nextinfo = nextNodeInfo.getAlarmLevel();
                } else if (selectColumn.equals(ALARM_MESSAGE)) {
                    currentinfo = currentNodeInfo.getAlarmMessage();
                    nextinfo = nextNodeInfo.getAlarmMessage();
                } else if (selectColumn.equals(ALARM_CONFIRM)) {
                    currentinfo = currentNodeInfo.getAlarmConfirm();
                    nextinfo = nextNodeInfo.getAlarmConfirm();
                } else if (selectColumn.equals(ALARM_DATE)) {
                    currentinfo = currentNodeInfo.getAlarmID();
                    nextinfo = nextNodeInfo.getAlarmID();

                    long currentValue = Integer.parseInt(currentinfo);
                    long nextValue = Integer.parseInt(nextinfo);

                    resultCompareNumber = (int) (currentValue - nextValue);
                    nodeInfoList =
                        swapRow(nodeInfoList, checkPoint, resultCompareNumber);

                    continue;
                }

                resultCompareNumber = (currentinfo).compareTo(nextinfo);
                nodeInfoList =
                    swapRow(nodeInfoList, checkPoint, resultCompareNumber);
            }
        }

        return nodeInfoList;
    }

    public ArrayList swapRow(
        ArrayList nodeInfoList, final int rowPosition,
        final int resultCompareNumber) {
        if (isOrderDirection.equals(SORT_DIRECTION_ASC)) {
            if (resultCompareNumber < 0) {
                nodeInfoList = swap(nodeInfoList, rowPosition);
            } else if (resultCompareNumber == 0) {
                nodeInfoList = resortRow(nodeInfoList, rowPosition);
            }
        } else {
            if (resultCompareNumber > 0) {
                nodeInfoList = swap(nodeInfoList, rowPosition);
            } else if (resultCompareNumber == 0) {
                nodeInfoList = resortRow(nodeInfoList, rowPosition);
            }
        }

        return nodeInfoList;
    }

    public ArrayList resortRow(ArrayList alarmInfoList, int rowPosition) {
        AlarmInformation currentMibInfo =
            (AlarmInformation) alarmInfoList.get(rowPosition);
        AlarmInformation nextMibInfo =
            (AlarmInformation) alarmInfoList.get(rowPosition - 1);

        String currentAlarmInfoString = "";
        String nextAlarmInfoString = "";
        currentAlarmInfoString = currentMibInfo.getAlarmDate();
        nextAlarmInfoString = nextMibInfo.getAlarmDate();

        if (isOrderDirection.equals(SORT_DIRECTION_ASC)) {
            if ((currentAlarmInfoString).compareTo(nextAlarmInfoString) < 0) {
                alarmInfoList = swap(alarmInfoList, rowPosition);
            }
        } else {
            if ((currentAlarmInfoString).compareTo(nextAlarmInfoString) > 0) {
                alarmInfoList = swap(alarmInfoList, rowPosition);
            }
        }

        return alarmInfoList;
    }

    public ArrayList swap(ArrayList nodeInfoList, int rowPosition) {
        Object work = nodeInfoList.get(rowPosition);
        nodeInfoList.set(rowPosition, nodeInfoList.get(rowPosition - 1));
        nodeInfoList.set(rowPosition - 1, work);

        return nodeInfoList;
    }
}
