/*
 * Created on 2004/12/25
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.alarm.view.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionAlarmFilter;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * A[tB^[̎擾yѐݒs\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AlarmViewFilterModel {
    /* MO */
    private static Logger logger = null;

    public AlarmViewFilterModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public ArrayList getList(String engineAddress)
        throws EngineConnectException, IOException {
        ArrayList alarmList = null;

        ConnectionAlarmFilter connection = null;

        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            String testEngineAddress =
                ((EngineResourceInfo) engineList.get(0)).getEngineIPaddress();

            alarmList = new ArrayList();

            try {
                connection = new ConnectionAlarmFilter(testEngineAddress);
                alarmList = connection.getAlarmIFilterList();
            } catch (EngineConnectException e) {
                logger.info("abort engine : " + testEngineAddress);
                logger.info(e.getMessage());
            } catch (IOException e) {
                logger.info("abort engine : " + testEngineAddress);
                logger.info(e.getMessage());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            logger.warning("Illegal Engine address : " + engineAddress);
        }

        return alarmList;
    }

    public void setAlarmFilter(
        String engineAddress, AlarmViewFilter alarmViewFilter)
        throws EngineConnectException, IOException {
        ConnectionAlarmFilter connection = null;

        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();

            for (int i = 0; i < engineList.size(); i++) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
                logger.info("Check engine connect : " + testEngineAddress);

                try {
                    connection = new ConnectionAlarmFilter(testEngineAddress);
                    connection.updateAlarmIFilter(alarmViewFilter);
                } catch (EngineConnectException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (IOException e) {
                    logger.info("abort engine : " + testEngineAddress);
                    logger.info(e.getMessage());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            logger.warning("Illegal Engine address : " + engineAddress);
        }
    }
}
