/*
 * Created on 2006/08/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.connectstate;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;
import netjfwatcher.test.model.TestNetWatch;


/**
 * GWƂ̐ڑ𐧌䂷ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineConnectInfoControlAction extends HttpServlet {
    private static Logger logger = null;

    /* Postp[^i[z */
    private String postEngineAddress;
    private String postEnginePort;
    private String postEngineTimeout;
    private String postEngineXMLSocketPort;

    /* m[hĎPostp[^[,]ŕvfi[z */
    private String[] engineAddress;
    private String[] enginePort;
    private String[] engineTimeout;
    private String[] engineXMLSocketPort;
    private String reportPort;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        /*
        Enumeration parameters = request.getParameterNames();

        while (parameters.hasMoreElements()) {
        String parameter = (String) parameters.nextElement();
        System.out.println("Post param : " + parameter);
        System.out.println(
        "Post value : " + request.getParameter(parameter));
        }
        */
        String mode = request.getParameter("mode");

        if (mode.equals("load")) {
            this.loadEngineList(request, response);
        } else if (mode.equals("update")) {
            this.saveEngineList(request, response);
        } else if (mode.equals("test")) {
            this.testEngineConnect(request, response);
        }
    }

    private void loadEngineList(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException {
        String serverAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();
        out.print("EngineCount=" + engineList.size());

        int nodeCount;

        for (nodeCount = 0; nodeCount < engineList.size(); nodeCount++) {
            out.print(
                "&EngineIPAddress" + nodeCount + "="
                + ((EngineResourceInfo) engineList.get(nodeCount))
                .getEngineIPaddress());
            out.print(
                "&EnginePort" + nodeCount + "="
                + ((EngineResourceInfo) engineList.get(nodeCount))
                .getEnginePort());
            out.print(
                "&EngineTimeout" + nodeCount + "="
                + ((EngineResourceInfo) engineList.get(nodeCount))
                .getEngineTimeout());
            out.print(
                "&EngineFlashXMLSocketPort" + nodeCount + "="
                + ((EngineResourceInfo) engineList.get(nodeCount))
                .getEngineFlashXMLSocketPort());
        }

        String xmlSocketReportPort =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getClientXmlSocketPort();

        out.print("&EngineXMLSocketReportPort=" + xmlSocketReportPort);
    }

    private void saveEngineList(
        HttpServletRequest request, HttpServletResponse response) {
        getPostParameter(request);

        if (checkPostParameter()) {
            ArrayList engineInfoList = new ArrayList();

            for (int i = 0; i < engineAddress.length; i++) {
                if ((engineAddress[i] != null) && !engineAddress[i].equals("")) {
                    logger.info("engineAddress" + i + " " + engineAddress[i]);
                    logger.info("enginePort" + i + " " + enginePort[i]);
                    logger.info("engineTimeout" + i + " " + engineTimeout[i]);
                    logger.info(
                        "engineXMLSocketPort" + i + " "
                        + engineXMLSocketPort[i]);

                    EngineResourceInfo engineInfo = new EngineResourceInfo();
                    engineInfo.setEngineIPaddress(engineAddress[i]);
                    engineInfo.setEnginePort(enginePort[i]);
                    engineInfo.setEngineTimeout(engineTimeout[i]);
                    engineInfo.setEngineFlashXMLSocketPort(
                        engineXMLSocketPort[i]);
                    engineInfoList.add(engineInfo);
                }
            }

            logger.info("Report Port " + reportPort);

            String clientXmlSocketPort =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getClientXmlSocketPort();

            String nodeRegisterReportPort = clientXmlSocketPort;

            try {
                /* Flash̕svR[h폜 */
                nodeRegisterReportPort =
                    Integer.toString(Integer.parseInt(reportPort));
            } catch (NumberFormatException e) {
                logger.warning("Error Report Port " + reportPort);
            }

            EngineResourceConfig.getInstance().getEngineInfo()
                                .updateEngineResource(
                engineInfoList, nodeRegisterReportPort);
        }
    }

    private void testEngineConnect(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException {
        TestNetWatch test = new TestNetWatch();
        String result = test.testEngine();

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
        out.print("Result=" + result);
        logger.info("Engine connect test Result=" + result);
    }

    /*
     * m[hMap Savẽ|Xgp[^𒊏o܂B
     *
     * @param request HttpServletRequest
     */
    private void getPostParameter(HttpServletRequest request) {
        /* m[hĎp[^擾 */
        postEngineAddress = request.getParameter("engineAddress");
        postEnginePort = request.getParameter("enginePort");
        postEngineTimeout = request.getParameter("engineTimeout");
        postEngineXMLSocketPort = request.getParameter("engineXMLSocket");

        reportPort = request.getParameter("reportPort");
    }

    /*
     * m[hMap Savẽ|Xgp[^̑Ó`FbN܂B
     *
     */
    private boolean checkPostParameter() {
        // 𕪊Pattern
        Pattern pattern = null;

        // tB[hɃtB[h؂ŕ
        try {
            pattern = Pattern.compile(",");
        } catch (PatternSyntaxException e) {
            logger.severe("Error compiling expression : " + e.getMessage());

            return false;
        }

        if (postEngineAddress == null) {
            return false;
        }

        engineAddress = pattern.split(postEngineAddress);

        if (engineAddress.length < 1) {
            return false;
        }

        enginePort = pattern.split(postEnginePort);

        if (enginePort.length == 0) {
            enginePort = new String[engineAddress.length];
        }

        engineTimeout = pattern.split(postEngineTimeout);

        if (engineTimeout.length == 0) {
            engineTimeout = new String[engineAddress.length];
        }

        engineXMLSocketPort = pattern.split(postEngineXMLSocketPort);

        if (engineXMLSocketPort.length == 0) {
            engineXMLSocketPort = new String[engineAddress.length];
        }

        return true;
    }
}
