/*
 * Created on 2004/04/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.connectstate.model;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * GWƂ̐ڑ󋵂擾郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineConnectStateModel {
    /* MO */
    private static Logger logger;

    /**
     * GWƂ̐ڑ󋵂擾郁\bhNXCX^XԂ܂
     *
     */
    public EngineConnectStateModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWƂ̐ڑ󋵃XgԂ܂B
     *
     * @return engineStateList GWƂ̐ڑ󋵃Xg
     */
    public ArrayList getEngineConnectState() {
        ArrayList engineStateList = new ArrayList();

        /* GWڑOK */
        int connectOKEngineNo = 0;

        ArrayList engineList =
            EngineResourceConfig.getInstance().getEngineInfo()
                                .getEngineInfoList();

        /*
         * o^EngineSĂɏڑAڑOK Enginem[hĎ񃊃Xg
         * 擾
         */
        for (int i = 0; i < engineList.size(); i++) {
            String testEngineAddress =
                ((EngineResourceInfo) engineList.get(i)).getEngineIPaddress();
            String testEnginePort =
                ((EngineResourceInfo) engineList.get(i)).getEnginePort();
            EngineConnectState engineConnectState = new EngineConnectState();

            String ipAddress = null;
            String hostName = null;

            try {
                InetAddress host = InetAddress.getByName(testEngineAddress);
                ipAddress = host.getHostAddress();
                hostName = host.getHostName();
            } catch (UnknownHostException e) {
                /* m[hIP Addressُ */
                logger.warning(
                    "UnknownHostException : " + " Engine IP Address = "
                    + testEngineAddress + " " + e.getMessage());
            }

            engineConnectState.setEngineHostname(hostName);
            engineConnectState.setEngineAddress(ipAddress);
            engineConnectState.setEnginePort(testEnginePort);
            logger.info("Check engine connect : " + testEngineAddress);

            try {
                /* EngineƐڑm[h擾邽߂̃CX^X */
                ConnectionNodeInformation nodeInfoConnection = null;
                nodeInfoConnection =
                    new ConnectionNodeInformation(testEngineAddress);

                ArrayList workNodeInfoList = null;
                workNodeInfoList =
                    nodeInfoConnection.getNodeInformationList(null, null);
                connectOKEngineNo++;

                if ((workNodeInfoList != null) && (workNodeInfoList.size() > 0)) {
                    /*
                     * ڑOK Enginem[hĎ擾
                     */
                    for (int j = 0; j < workNodeInfoList.size(); j++) {
                        NodeInformation nodeInfo =
                            (NodeInformation) workNodeInfoList.get(j);
                    }
                }

                engineConnectState.setEngineConnectState("Connect OK");
            } catch (EngineConnectException e) {
                logger.warning(e.getMessage());
                engineConnectState.setEngineConnectState(
                    "EngineConnectException " + e.getMessage());
            } catch (IOException e) {
                logger.warning(e.getMessage());
                engineConnectState.setEngineConnectState(
                    "IOException " + e.getMessage());
            } catch (Exception e) {
                logger.warning(e.getMessage());
                engineConnectState.setEngineConnectState(
                    "Exception " + e.getMessage());
            }

            engineStateList.add(engineConnectState);
        }

        if (connectOKEngineNo < 1) {
            /*
             * ڑOK EngineȂΈُƂA
             * łΏpƂ
             */
            if (engineList.size() > 0) {
                String testEngineAddress =
                    ((EngineResourceInfo) engineList.get(0)).getEngineIPaddress();
                String testEnginePort =
                    ((EngineResourceInfo) engineList.get(0)).getEnginePort();
                logger.warning(
                    "Engine connect abort Engine Address=" + testEngineAddress
                    + ", Engine Port=" + testEnginePort);
            }
        }

        return engineStateList;
    }
}
