/*
 * Created on 2004/12/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.socket.info.AlarmViewFilter;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWƃA[tB^[̑Ms\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionAlarmFilter extends AbstractConnectionEngine {
    /**
     * GWƃA[tB^[̑Ms\bh
     * NXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionAlarmFilter(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * A[tB^[擾܂B
     *
     * @param sortColumn \[gΏۃJ
     * @param sortDirection \[g
     * @return responseList A[tB^[񃊃Xg
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getAlarmIFilterList()
        throws EngineConnectException, IOException {
        AlarmViewFilter alarmFilterInfo = new AlarmViewFilter();
        alarmFilterInfo.setSubCommand(AlarmViewFilter.ALARM_FILTER_GET);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setAlarmFilterInfo(alarmFilterInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.ALARM_FILTER_COMMAND_ID);

        ArrayList responseList = null;
        responseList = (ArrayList) this.communicationToEngine(commnadInfo);

        return responseList;
    }

    /**
     * A[tB^[XV܂B
     *
     * @param alarmFilterInfo A[tB^[
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void updateAlarmIFilter(final AlarmViewFilter alarmFilterInfo)
        throws EngineConnectException, IOException {
        alarmFilterInfo.setSubCommand(AlarmViewFilter.ALARM_FILTER_SET);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setAlarmFilterInfo(alarmFilterInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.ALARM_FILTER_COMMAND_ID);

        this.communicationToEngine(commnadInfo);
    }
}
