/*
 * Created on 2004/06/05
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.DatabasePropertyInfoList;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWƃf[^x[XvpeB̑Ms\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionDatabasePropertyGet extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger = null;

    /**
     * GWƃf[^x[XvpeB̑Ms\bh
     * NXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionDatabasePropertyGet(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[XvpeB擾܂B
     *
     * @return databaseProp f[^x[XvpeB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public DatabasePropertyInfo[] getResource()
        throws EngineConnectException, IOException {
        DatabasePropertyInfoList databasePropList = null;
        DatabasePropertyInfo[] databaseProp = null;

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.DATABASE_PROPERTY_GET_COMMAND_ID);
        databasePropList =
            (DatabasePropertyInfoList) this.communicationToEngine(commandInfo);
        databaseProp = databasePropList.getDatabasePropInfoList();

        if (databaseProp != null) {
            for (int i = 0; i < databaseProp.length; i++) {
                logger.info(
                    "Database Name No." + i + "="
                    + databaseProp[i].getDatabaseName());
            }
        }

        return databaseProp;
    }
}
