/*
 * Created on 2004/12/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWInterface MIB̑Ms\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionInterfaceMib extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger;

    /**
     * GWInterface MIB̑Ms\bh
     * NXCX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionInterfaceMib(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Interface MIB擾܂B
     *
     * @param ipAddress m[hIPAhX
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getInterfaceMib(final String ipAddress)
        throws EngineConnectException, IOException {
        logger.info("IP=" + ipAddress);

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.INTERFACE_MIB_GET_COMMAND_ID);
        commandInfo.setIpaddress(ipAddress);

        ArrayList responseList = null;
        responseList = (ArrayList) this.communicationToEngine(commandInfo);

        return responseList;
    }
}
