/*
 * Created on 2003/08/02
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;

import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.engine.socket.info.MibInfo;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.snmp.preference.SnmpPreference;


/**
 * MIB̎vGWɒʒmA̎f[^擾NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionMibGet extends AbstractConnectionEngine {
    /**
     * MIB̎vGWɒʒmA̎f[^擾NX
     * CX^X𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionMibGet(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * MIB̎(GetNextR}h)s܂B
     *
     * @param targetIPAddress m[hIPAhX
     * @param version SNMPo[W
     * @param requestMibOid OID
     * @param community R~jeB
     * @return mibGetResponseList MIB̎挋
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public MibGetResponseList mibGet(
        final String targetIPAddress, final String version,
        final String requestMibOid, final String community)
        throws EngineConnectException, IOException {
        MibGetResponseList mibGetResponseList = null;

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(CommandMappingTableResource.MIBGET_COMMAND_ID);
        commandInfo.setIpaddress(targetIPAddress);

        MibInfo mibInfo = new MibInfo();

        mibInfo.setRoCommunity(community);
        mibInfo.setRequestMibOid(requestMibOid);

        if (version.equals("SNMPV1")) {
            mibInfo.setVersion(SnmpPreference.SNMP_VERSION_1);
        } else if (version.equals("SNMPV2C")) {
            mibInfo.setVersion(SnmpPreference.SNMPV2C);
        } else if (version.equals("SNMPV3")) {
            mibInfo.setVersion(SnmpPreference.SNMPV3);
        } else {
            mibInfo.setVersion(SnmpPreference.SNMP_VERSION_1);
        }

        commandInfo.setMibInfo(mibInfo);

        mibGetResponseList =
            (MibGetResponseList) this.communicationToEngine(commandInfo);

        return mibGetResponseList;
    }
}
