/*
 * Created on 2004/12/15
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.ArrayList;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.command.control.CommandMappingTableResource;


/**
 * GWm[hĎ擾NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionNodeInformation extends AbstractConnectionEngine {
    /** m[hĎ擾R}hR[h */
    public static final String NODE_INFORMATION = "Node Info";

    /** m[hĎ񃊃Xg擾R}hR[h */
    public static final String NODE_INFORMATION_LIST = "Node Info List";

    /**
     * GWm[hĎ擾NXCX^X
     * ܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionNodeInformation(final String engineAddress) {
        super(engineAddress);
    }

    /**
     * wm[h̃m[hGW擾ĕԂ܂B
     *
     * @param ipaddress m[hIPAhX
     * @return nodeInformation m[hĎ
    * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
    * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public NodeInformation getNodeInformation(final String ipaddress)
        throws EngineConnectException, IOException {
        NodeInformation nodeInfo = new NodeInformation();
        nodeInfo.setSubCommand(NODE_INFORMATION);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeInformation(nodeInfo);
        commnadInfo.setIpaddress(ipaddress);
        commnadInfo.setCode(
            CommandMappingTableResource.NODE_INFORMATION_COMMAND_ID);

        NodeInformation nodeInformation = null;
        ArrayList list = (ArrayList) this.communicationToEngine(commnadInfo);

        if (list.size() > 0) {
            nodeInformation = (NodeInformation) list.get(0);
        }

        return nodeInformation;
    }

    /**
     * wGWAhXɓo^Ăm[h~܂͏ɃXgƂĎ擾
     * Ԃ܂B
     *
     * @param sortColumn \[gJ
     * @param sortDirection \[g
     * @return nodeList o^m[hXg
    * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
    * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ArrayList getNodeInformationList(
        final String sortColumn, final String sortDirection)
        throws EngineConnectException, IOException {
        NodeInformation nodeInfo = new NodeInformation();
        nodeInfo.setSortColumn(sortColumn);
        nodeInfo.setSortDirection(sortDirection);
        nodeInfo.setSubCommand(NODE_INFORMATION_LIST);

        CommandInfo commnadInfo = new CommandInfo();
        commnadInfo.setNodeInformation(nodeInfo);
        commnadInfo.setCode(
            CommandMappingTableResource.NODE_INFORMATION_COMMAND_ID);

        ArrayList nodeList =
            (ArrayList) this.communicationToEngine(commnadInfo);

        return nodeList;
    }
}
