/*
 * Created on 2003/08/25
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.graph.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionInterfaceData;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.InterfaceData;
import netjfwatcher.snmp.preference.SnmpPreference;


/**
 * m[h̃C^tF[Ẍȉ̏f[^x[X擾ĕԂ܂B
 *
 *
 * EifInOctets 1.3.6.1.2.1.2.2.1.10 if:MINebg
 * EfOutOctets 1.3.6.1.2.1.2.2.1.16 if:MINebg
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class InterfaceGaphInfo {
    /* MO */
    private static Logger logger = null;

    /**
     * m[h̃C^tF[Ẍȉ̏f[^x[X擾ăXgƂĕԂ܂B
     * C^tF[XifInOctets/fOutOctets̏ŃXgɊi[܂B
     *
     * EifInOctets 1.3.6.1.2.1.2.2.1.10 if:MINebg
    @* EifOutOctets 1.3.6.1.2.1.2.2.1.16 if:MINebg
     *
     * @param engineAddress GWAhX
     * @param ipaddress m[hIP Address
     * @param mode /ώZ\̂ꂩ\idifference()/integral(ώZ)j
     * @return returnList if:MINebgf[^i[Xgif:MINebgf[^i[Xg
     * i[Xg
     *
     * @throws EngineConnectException GWƂ̐ڑɎsꍇ
     * @throws IOException GWƂ̐ڑɎsꍇ
     */
    public ArrayList findAll(
        String engineAddress, String ipaddress, String mode)
        throws EngineConnectException, IOException {
        /* if:MINebgf[^i[Xg */
        ArrayList ifinlist;

        /* if:MINebgf[^i[Xg */
        ArrayList ifoutlist;

        /*
         * if:MINebgf[^i[Xgif:MINebgf[^i[Xg
         * i[Xg
         */
        ArrayList returnList = new ArrayList();

        ConnectionInterfaceData connectionStatisticsMibGet =
            new ConnectionInterfaceData(engineAddress);

        /*
         * ifInOctets 1.3.6.1.2.1.2.2.1.10 if:MINebgf[^擾
         */
        String oid = SnmpPreference.IFINOCTETS_OID;
        ifinlist =
            connectionStatisticsMibGet.getInterfaceData(ipaddress, oid, mode);

        /*
         * ifOutOctets 1.3.6.1.2.1.2.2.1.16 if:MINebgf[^擾
         */
        oid = SnmpPreference.IFOUTOCTETS_OID;
        ifoutlist =
            connectionStatisticsMibGet.getInterfaceData(ipaddress, oid, mode);

        // System.out.println("mode : " + mode);

        /* ώZ\\ */
        if (mode.equals("difference")) {
            /* f[^ */
            ifinlist = this.diffgetList(ifinlist);
            ifoutlist = this.diffgetList(ifoutlist);
        }

        /*
         * ifInOctets/ifOutOctetsf[^AXgɒǉ
         */
        for (int i = 0; ((ifinlist.size() > i) && (ifoutlist.size() > i));
                i++) {
            returnList.add(ifinlist.get(i));
            returnList.add(ifoutlist.get(i));
        }

        return returnList;
    }

    /**
     * w̎Wf[^Xg獷f[^𐶐ĕԂ܂B
     * \ɂf[^Xgɂ́AŐVf[^ێInterfaceDataNXCX^X
     * Õf[^ێInterfaceDataNXCX^Xi[Ă܂B
     *
     *
     * ifInOctets
     * ifOutOctets
     *
     * @param difflist Wf[^
     * @return returnList
     */
    public ArrayList diffgetList(ArrayList difflist) {
        // f[^i[Xg
        ArrayList returnList = new ArrayList();
        InterfaceData interfaceinfo = null;

        /*
         *@ŐVf[^ƈÕf[^獷lZo
         * iXg̃TCY͍ŐVƈÕf[^i[Ă̂2łj
         */
        for (int i = 0; ((difflist.size() / 2) - 1) >= i; i++) {
            interfaceinfo = new InterfaceData();

            String instanceName =
                ((InterfaceData) (difflist.get(i))).getInstanceName();

            /*
             * Oƍ̍̎f[^擾
             */

            // f[^
            double thisdata =
                Double.parseDouble(
                    ((InterfaceData) (difflist.get(i))).getInstanceValue());

            // Of[^
            double predata =
                Double.parseDouble(
                    ((InterfaceData) (difflist.get(i + (difflist.size() / 2))))
                    .getInstanceValue());

            /*
             * ̎ԊuPʎԂZo
             * iOƍ̍̎玞ԍZoĒPʎԎZô߂̎ԂƂj
             */
            long nexttime =
                ((InterfaceData) (difflist.get(i))).getDate().getTime();
            long nowtime =
                ((InterfaceData) (difflist.get(i + (difflist.size() / 2)))).getDate()
                 .getTime();
            long difftime = (nexttime - nowtime) / 1000; // Pʎ

            /*
            System.out.println("nexttime : " + nexttime);
            System.out.println("nowtime : " + nowtime);
            System.out.println("difftime : " + difftime);

            System.out.println("i : " + i);
            System.out.println("difflist.size()/2 : " + (difflist.size() / 2));
            System.out.println("instance_name : " + instanceName);
            System.out.println("thisdata : " + thisdata);
            System.out.println("predata : " + predata);
            System.out.println(Double.toString(thisdata - predata));
            */
            /*
             * PʎԂ̃pPbgƃCX^Xi[
             */
            interfaceinfo.setInstanceName(instanceName);

            if (difftime != 0) {
                interfaceinfo.setInstanceValue(
                    Double.toString((thisdata - predata) / difftime));
            } else {
                interfaceinfo.setInstanceValue("0");
            }

            returnList.add(interfaceinfo);
        }

        return returnList;
    }
}
