/*
 * Created on 2004/05/18
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.action;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * Session𖳌ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SessionControlAction extends Action {
    /* MO */
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);

        HttpSession session = request.getSession();
        logger.info(
            "session MaxInactiveInterval : "
            + session.getMaxInactiveInterval());
        logger.info(
            "session LastAccessedTime : " + session.getLastAccessedTime());
        logger.info("session CreationTime : " + session.getCreationTime());
        logger.info("session ServletContext : " + session.getServletContext());

        session.setMaxInactiveInterval(1);
        session.invalidate();

        return mapping.findForward(Preference.SUCCESS);
    }
}
