/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.flashaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;
import netjfwatcher.maintenance.model.GarbageCollectionMonitorModel;
import netjfwatcher.preference.Preference;


/**
 * GarbageCollectionf[^̎Jn/~yуf[^[hGWɒʒm
 * ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class GarbageCollectionMonitorAction extends HttpServlet {
    /* MO */
    private static Logger logger = null;

    /* GWAhX */
    private String engineAddress = null;

    public void doPost(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, ServletException {
        logger = Logger.getLogger(this.getClass().getName());

        engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not server Address");
            engineAddress = "localhost";
        }

        String mode = request.getParameter(Preference.GRAPH_MODE);

        if (mode.equals("load")) {
            try {
                this.loadGarbageCollectionInfo(request, response);
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        } else if (mode.equals("start")) {
            try {
                this.startGarbageCollection(request, response);
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        } else if (mode.equals("stop")) {
            try {
                this.stopGarbageCollection(request, response);
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        } else {
            logger.warning("Unknown mode : " + mode);
        }
    }

    /*
     * GarbageCollectionf[^̎jJn܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     * @throws Exception 炩ُ̈킪ꍇ
     */
    private void startGarbageCollection(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, Exception {
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
        GarbageCollectionMonitorModel model =
            new GarbageCollectionMonitorModel();
        String interval = request.getParameter("interval");
        GarbageCollectionControl info =
            model.sartGarbageCollectionThread(engineAddress, interval);

        out.print("&threadState=" + info.isThreadState());
    }

    /*
     * GarbageCollectionf[^̎~܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     * @throws Exception 炩ُ̈킪ꍇ
     */
    private void stopGarbageCollection(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, Exception {
        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();
        GarbageCollectionMonitorModel model =
            new GarbageCollectionMonitorModel();

        GarbageCollectionControl info =
            model.stopGarbageCollectionThread(engineAddress);

        out.print("&threadState=" + info.isThreadState());

        // System.out.println("&threadState=" + info.isThreadState());
    }

    /*
     * GarbageCollectionf[^GW烍[h܂B
     *
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     * @throws Exception 炩ُ̈킪ꍇ
     */
    private void loadGarbageCollectionInfo(
        HttpServletRequest request, HttpServletResponse response)
        throws IOException, Exception {
        String starttime =
            request.getParameter(Preference.START_YY) + "-"
            + request.getParameter(Preference.START_MM) + "-"
            + request.getParameter(Preference.START_DD) + " "
            + request.getParameter(Preference.START_HH) + ":"
            + request.getParameter(Preference.START_MIN) + ":00.0";
        String endtime =
            request.getParameter(Preference.END_YY) + "-"
            + request.getParameter(Preference.END_MM) + "-"
            + request.getParameter(Preference.END_DD) + " "
            + request.getParameter(Preference.END_HH) + ":"
            + request.getParameter(Preference.END_MIN) + ":00.0";
        int itemnum =
            Integer.parseInt(
                request.getParameter(Preference.GRAPH_ITEM_NUMBER));

        String notchMode = request.getParameter(Preference.GRAPH_NOTCH);

        response.setContentType("text/plain");

        PrintWriter out = response.getWriter();

        GarbageCollectionMonitorModel model =
            new GarbageCollectionMonitorModel();

        GarbageCollectionControl info =
            model.getGarbageCollectionInfo(engineAddress, starttime, endtime);

        if (info == null) {
            logger.warning("Abort get GarbagCollection Memory Information");

            return;
        }

        long dataCount = info.getGarbagCollectionMemoryList().size();

        DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        out.print("totalDataCount" + "=" + info.getTotalDataCount());

        if (info.getStartDate() != null) {
            out.print(
                "&startDate" + "=" + dateformat.format(info.getStartDate()));
        }

        if (info.getEndDate() != null) {
            out.print(
                "&endDate" + "=" + dateformat.format(info.getEndDate()));
        }

        out.print("&minData" + "=" + info.getFreeMemoryMinData());
        out.print("&maxData" + "=" + info.getFreeMemoryMaxData());
        out.print("&totalMemoryMinData" + "=" + info.getTotalMemoryMinData());
        out.print("&totalMemoryMaxData" + "=" + info.getTotalMemoryMaxData());
        out.print("&dataCount=" + dataCount);
        out.print("&threadState=" + info.isThreadState());
        out.print("&maxMemory=" + info.getMaxMemory());

        long[] resFreeMemoryData = new long[(int) dataCount];
        long[] resTotalMemoryData = new long[(int) dataCount];
        String[] resTime = new String[(int) dataCount];

        // Date checkDate = Calendar.getInstance().getTime();
        long workCount = 0;

        if (itemnum > dataCount) {
            workCount = dataCount;

            // out.println("&dataCNT=" + dataCount);
            // System.out.println("&dataCNT=" + dataCount);
        } else {
            workCount = itemnum;

            // out.println("&dataCNT=" + itemnum);
            // System.out.println("&dataCNT=" + " : itemnum : " + itemnum);
        }

        for (int i = 0; i < dataCount; i++) {
            if (i > itemnum) {
                /*
                 * ݎw肪ꍇɂ́Aw̍ő\ڐ𒴂Ă
                 * f[^Zbg
                 */
                if (notchMode.equals("No")) {
                    break;
                }
            }

            GarbageCollectionInfo garinfo =
                (GarbageCollectionInfo) info.getGarbagCollectionMemoryList()
                                            .get(i);
            resFreeMemoryData[i] = garinfo.getFreeMemory();
            resTotalMemoryData[i] = garinfo.getTotalMemory();

            // DateFormat dateformat
            // = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateformat = new SimpleDateFormat("HH:mm:ss");
            resTime[i] = dateformat.format(garinfo.getCheckDate());
        }

        long sendDataCount = 0;
        long notch = 1;

        if (notchMode.equals("No")) {
            notch = 1;
        } else if (notchMode.equals("Auto")) {
            while ((workCount / notch) > 40) {
                notch += 20;
            }
        } else {
            try {
                notch = Integer.parseInt(notchMode);
            } catch (NumberFormatException e) {
            }
        }

        sendDataCount = workCount / notch;

        // out.println("&dataCNT=" + dataCount);
        out.print("&dataCNT" + "=" + sendDataCount);

        for (
            int count = 0, notchCount = 0; count < sendDataCount;
                count++, notchCount++) {
            out.print(
                "&dataOUTFreeMemory" + count + "="
                + resFreeMemoryData[notchCount]);
            out.print(
                "&dataOUTTotalMemory" + count + "="
                + resTotalMemoryData[notchCount]);
            out.print("&dataDATE" + count + "=" + resTime[notchCount]);
            notchCount += (notch - 1);
        }
    }
}
