/*
 * Created on 2003/08/22
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.maintenance.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.socket.ConnectionResourceGet;
import netjfwatcher.engine.socket.ConnectionResourceSet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.ResourceInfo;
import netjfwatcher.library.ResourceInfoFromEngine;
import netjfwatcher.resourceconfig.EngineResourceConfig;
import netjfwatcher.resourceconfig.EngineResourceInfo;


/**
 * \[X擾EXVsNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ResourceManagementModel {
    private static Logger logger = null;

    public ResourceManagementModel() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[XvpeBXV܂B
     *
     * @param engineAddress GWAhX
     * @param databaseName f[^x[X
     * @param databaseDriver f[^x[XhCo
     * @param databaseURL f[^x[XURL
     * @param databaseUser f[^x[X[U
     * @param databasePassword f[^x[XpX[h
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public void updateDatabasePropResource(
        String engineAddress, String databaseName, String databaseDriver,
        String databaseURL, String databaseUser, String databasePassword)
        throws EngineConnectException, IOException {
        ConnectionResourceGet resourceGet =
            new ConnectionResourceGet(engineAddress);
        ResourceInfo resourceInfo = resourceGet.getResource();

        resourceInfo.setDatabaseName(databaseName);
        resourceInfo.setDatabaseDriver(databaseDriver);
        resourceInfo.setDatabaseUrl(databaseURL);
        resourceInfo.setDatabaseUser(databaseUser);
        resourceInfo.setDatabasePassword(databasePassword);

        ConnectionResourceSet resourceSet =
            new ConnectionResourceSet(engineAddress);
        resourceSet.setResource(resourceInfo);

        ResourceInfoFromEngine.getInstance().updateResourceset(engineAddress);
    }

    /**
     * \[XXV܂B
     *
     * @param engineAddress GWAhX
     * @param resourceInfo \[X
     * @return updateResourceInfo XVナ\[X
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ResourceInfo updateResource(
        String engineAddress, ResourceInfo resourceInfo)
        throws EngineConnectException, IOException {
        /*
         * \[Xi[CX^X𐶐AeZbg
         */

        // GWɃ\[XXVʒm
        ConnectionResourceSet resourceSet =
            new ConnectionResourceSet(engineAddress);
        ResourceInfo updateResourceInfo = null;

        try {
            updateResourceInfo = resourceSet.setResource(resourceInfo);
        } catch (EngineConnectException e) {
            logger.warning("Update resource : " + e.getMessage());
            e.printStackTrace();
            throw e;
        } catch (IOException e) {
            logger.warning("Update resource : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        // XVς݃\[Xԋp
        return updateResourceInfo;
    }

    /**
     * GWƂ̒ʐMŃ\[XMĂԂ܂B
     *
     * @param engineAddress GWAhX
     * @return resourceInfo \[X
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public ResourceInfo getResource(String engineAddress)
        throws EngineConnectException, IOException {
        if (engineAddress.equals("all")) {
            ArrayList engineList =
                EngineResourceConfig.getInstance().getEngineInfo()
                                    .getEngineInfoList();
            engineAddress =
                ((EngineResourceInfo) engineList.get(0)).getEngineIPaddress();
        }

        // Engine烊\[X擾
        ConnectionResourceGet resourceGet =
            new ConnectionResourceGet(engineAddress);
        ResourceInfo resourceInfo = resourceGet.getResource();

        return resourceInfo;
    }
}
