/*
 * Created on 2003/08/07
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.MibGetResponseList;
import netjfwatcher.miboperation.model.MibGetModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * wm[hiwIPAhXjMIB OID̎悵AʂԂANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibGetAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);
        String version = request.getParameter(Preference.SNMP_VERSION_STRING);
        String community = request.getParameter(Preference.SNMP_RO_COMMUNITY);
        String requestOid =
            request.getParameter(Preference.SNMP_REQUEST_MIB_OID);

        MibGetModel mibgetmodel = new MibGetModel();

        MibGetResponseList mibGetPesponseList =
            mibgetmodel.getMib(
                engineAddress, ipaddress, version, community, requestOid);
        String result = mibGetPesponseList.getResultCode();

        if (result.equals("OK")) {
            /* MIB̎ɐꍇ */
            ArrayList mibGetList = mibGetPesponseList.getMibgetresponseList();

            /*
            for (int i = 0; i < mibGetList.size(); i++) {
            MibGetResponse mibgetresponse =
            (MibGetResponse) mibGetList.get(i);
            logger.info(
            mibgetresponse.getMibOid() + " : "
            + mibgetresponse.getMibName() + " : "
            + mibgetresponse.getMibValue());

            }
            */
            request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
            request.setAttribute(Preference.SNMP_MIB_GET_LIST, mibGetList);

            return mapping.findForward(Preference.SUCCESS);
        } else {
            /* MIB̎Ɏsꍇ */
            request.setAttribute(Preference.SNMP_MIB_OP_RESULT, result);
            logger.warning("MIB Get Abort Result : " + result);

            return mapping.findForward(Preference.ABORT);
        }
    }
}
