/*
 * Created on 2004/06/29
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * MIB̎WindowI[vɂAMIB̎^[QbgIPAhXԂANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibGetPreAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        if (ipaddress == null) {
            ipaddress = "";
        }

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.IPADDRESS, ipaddress);

        request.setAttribute(Preference.SERVER_NAME, servername);

        String convIPAddress = ipaddress.replace('.', '_');
        request.setAttribute(Preference.CONV_IPADDRESS, convIPAddress);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
