/*
 * Created on 2004/07/07
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.miboperation;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * MIB Setr[\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibSetOperationAction extends Action {
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        ArrayList mibGetList = new ArrayList();

        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        request.setAttribute(Preference.SNMP_STATISTICS_TARGET_IPADDRESS, "");
        request.setAttribute(Preference.SNMP_READ_COMMUNITY, "");
        request.setAttribute(Preference.SNMP_VERSION, "testVersion");
        request.setAttribute(Preference.SNMP_MIB_GET_LIST, mibGetList);

        return mapping.findForward(Preference.SUCCESS);
    }
}
