/*
 * Created on 2004/04/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.list;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import netjfwatcher.alarm.view.model.AlarmViewModel;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.AlarmInformation;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.nodemanager.list.model.NodeListViewModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * m[h}l[W̃m[hXg\JSPNANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeInfoListViewAction extends Action {
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws EngineConnectException, IOException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        NodeListViewModel nodeListModel = new NodeListViewModel();
        ArrayList nodeList = nodeListModel.getList(engineAddress, null, null);

        ArrayList alarmList = null;
        AlarmInformation alarmInfo = null;

        for (int i = 0; i < nodeList.size(); ++i) {
            NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);

            if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL0)) {
                nodeInfo.setSnmpLevel(Preference.NO_SNMP);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL1)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_CONFIG);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL2)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_IFOCTETS);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL3)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_LALOAD);
            } else if (nodeInfo.getSnmpLevel().equals(Preference.SNMP_LEVEL4)) {
                nodeInfo.setSnmpLevel(Preference.SNMP_DISK);
            }

            AlarmViewModel alarmviewmodel =
                new AlarmViewModel(
                    nodeInfo.getIpaddress(), Preference.ALARM_DATE,
                    Preference.SORT_DIR_DESC);
            alarmList =
                alarmviewmodel.getAlarmList(
                    nodeInfo.getEngineAddress(), 0, 0, 0);

            if (alarmList.size() > 0) {
                alarmInfo = (AlarmInformation) alarmList.get(0);
            }
        }

        request.setAttribute(
            Preference.NODE_REGISTER_COUNT, Integer.toString(nodeList.size()));
        request.setAttribute(Preference.NODE_REGISTER_LIST, nodeList);
        request.setAttribute(
            Preference.SORT_DIRECTION, Preference.SORT_DIR_DESC);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);

        HttpSession session = request.getSession();

        /*
        logger.info(
            "session MaxInactiveInterval : " + session.getMaxInactiveInterval());
        logger.info(
            "session LastAccessedTime : " + session.getLastAccessedTime());
        logger.info("session CreationTime : " + session.getCreationTime());
        logger.info("session ServletContext : " + session.getServletContext());
        */
        if (session.getAttribute(Preference.AUTH_MODE) != null) {
            request.setAttribute(
                Preference.AUTH_MODE, session.getAttribute(
                    Preference.AUTH_MODE));

            return mapping.findForward(Preference.SUCCESS);
        } else {
            request.setAttribute(
                Preference.AUTH_MODE, Preference.AUTH_MODE_NOAUTH);

            return mapping.findForward(Preference.SUCCESS);
        }
    }
}
