/*
 * Created on 2004/05/13
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.maintenance.model.FlashResourceInformationModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * So^m[h̊ĎҏWr[\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AllNodeEditViewAction extends Action {
    /** ChJ[h */
    public static final String WILD_CARD = "*";
    private static Logger logger = null;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response)
        throws EngineConnectException, UnknownHostException, IOException {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
            engineAddress = "localhost";
        }

        NodeInformation noderegister = new NodeInformation();

        noderegister.setGroup(WILD_CARD);
        noderegister.setNodeKind(WILD_CARD);
        noderegister.setPingPeriod(WILD_CARD);
        noderegister.setPingThreshold(WILD_CARD);
        noderegister.setSnmpLevel(WILD_CARD);
        noderegister.setSnmpPeriod(WILD_CARD);
        noderegister.setRoCommunity(WILD_CARD);
        noderegister.setHttpPeriod(WILD_CARD);
        noderegister.setHttpUrl(WILD_CARD);
        noderegister.setHttpTimeout(WILD_CARD);
        noderegister.setPopPeriod(WILD_CARD);
        noderegister.setPopPort(WILD_CARD);
        noderegister.setPopUser(WILD_CARD);
        noderegister.setPopPassword(WILD_CARD);
        noderegister.setPopTimeout(WILD_CARD);
        noderegister.setSmtpPeriod(WILD_CARD);
        noderegister.setSmtpPort(WILD_CARD);
        noderegister.setSmtpSendAddress(WILD_CARD);
        noderegister.setSmtpTimeout(WILD_CARD);
        noderegister.setSmtpCheckHost(WILD_CARD);
        noderegister.setSmtpCheckUser(WILD_CARD);
        noderegister.setSmtpCheckPassword(WILD_CARD);
        noderegister.setSmtpCheckPort(WILD_CARD);
        noderegister.setSmtpCheckTimeout(WILD_CARD);

        // System.out.println(noderegister.getSnmpLevel());
        // System.out.println(noderegister.getNodeKind());

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        /*
         * m[hĎɂm[hʏ擾
         */
        FlashResourceInformationModel flashdata =
            new FlashResourceInformationModel();
        ArrayList workNodeKindList = flashdata.getIconLabelList();

        /*
         * m[hĎɂm[hʑIR{Boxf[^
         */
        ArrayList nodeKindList = new ArrayList();
        NodeInformation nodeKind = null;
        nodeKind = new NodeInformation();
        nodeKind.setNodeKind(WILD_CARD);
        nodeKindList.add(nodeKind);

        for (int i = 0; workNodeKindList.size() > i; i++) {
            nodeKind = new NodeInformation();
            nodeKind.setNodeKind((String) workNodeKindList.get(i));
            nodeKindList.add(nodeKind);
        }

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.NODE_REGISTER_INFO, noderegister);
        request.setAttribute(Preference.NODE_KIND_LIST, nodeKindList);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
