/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import java.net.InetAddress;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.nodemanager.listoperation.model.NodeEditModel;
import netjfwatcher.preference.Preference;
import netjfwatcher.engine.socket.info.NodeInformation;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * 폜Ώۃm[h̃m[hĎNCAgɕԂANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeDeleteIndicationAction extends Action {
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        // DBYIPAhX擾
        NodeEditModel nodeeditmodel = new NodeEditModel();

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        NodeInformation nodeInfo =
            nodeeditmodel.getEditNodeInfo(engineAddress, ipaddress);

        request.setAttribute(Preference.IPADDRESS, ipaddress);
        request.setAttribute(Preference.NODE_REGISTER_INFO, nodeInfo);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);
        request.setAttribute(Preference.SERVER_NAME, servername);

        return mapping.findForward(Preference.SUCCESS);
    }
}
