/*
 * Created on 2003/08/14
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemanager.listoperation;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.maintenance.model.FlashResourceInformationModel;
import netjfwatcher.nodemanager.listoperation.model.NodeEditModel;
import netjfwatcher.preference.Preference;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


/**
 * o^m[h̊ĎҏW邽߂ɁÃm[hĎ\邽
 * ̃ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeEditIndicationAction extends Action {
    private static Logger logger;

    public ActionForward execute(
        ActionMapping mapping, ActionForm form, HttpServletRequest request,
        HttpServletResponse response) throws Exception {
        logger = Logger.getLogger(this.getClass().getName());

        String engineAddress = request.getParameter(Preference.ENGINE_ADDRESS);

        if (engineAddress == null) {
            logger.warning("Not Engine Address");
        }

        // DBYIPAhX擾
        NodeEditModel nodeeditmodel = new NodeEditModel();

        String ipaddress = request.getParameter(Preference.IPADDRESS);

        NodeInformation nodeInfo =
            nodeeditmodel.getEditNodeInfo(engineAddress, ipaddress);

        request.setAttribute(Preference.IPADDRESS, ipaddress);

        /*
         * o^m[hҏWɂm[hʑIR{Box𐶐
         */
        FlashResourceInformationModel flashdata =
            new FlashResourceInformationModel();
        ArrayList workNodeKindList = flashdata.getIconLabelList();
        ArrayList nodeKindList = new ArrayList();
        NodeInformation nodeInfoKind = null;

        for (int i = 0; workNodeKindList.size() > i; i++) {
            nodeInfoKind = new NodeInformation();

            if (nodeInfo.getNodeKind().equals((String) workNodeKindList.get(i))) {
                nodeInfoKind.setNodeKind((String) workNodeKindList.get(i));
                nodeInfoKind.setSelected(" Selected ");
            } else {
                nodeInfoKind.setNodeKind((String) workNodeKindList.get(i));
                nodeInfoKind.setSelected("");
            }

            nodeKindList.add(nodeInfoKind);
        }

        /* m[hĎZbg */
        request.setAttribute(Preference.NODE_REGISTER_INFO, nodeInfo);

        /* m[hʑIR{BoxZbg */
        request.setAttribute(Preference.NODE_KIND_LIST, nodeKindList);

        String servernamework1 =
            InetAddress.getLocalHost().toString().replace('.', '_');
        String servernamework2 = servernamework1.replace('/', '_');
        String servername = servernamework2.replace('-', '_');

        request.setAttribute(Preference.SERVER_NAME, servername);
        request.setAttribute(Preference.ENGINE_ADDRESS, engineAddress);

        return mapping.findForward(Preference.SUCCESS);
    }
}
